package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementClientDependencyMatch;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementClientDependencyMatcher;

/**
 * A pattern-specific query specification that can instantiate NamedElementClientDependencyMatcher in a type-safe way.
 * 
 * @see NamedElementClientDependencyMatcher
 * @see NamedElementClientDependencyMatch
 * 
 */
@SuppressWarnings("all")
public final class NamedElementClientDependencyQuerySpecification extends BaseGeneratedEMFQuerySpecification<NamedElementClientDependencyMatcher> {
  private NamedElementClientDependencyQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static NamedElementClientDependencyQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected NamedElementClientDependencyMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return NamedElementClientDependencyMatcher.on(engine);
  }
  
  @Override
  public NamedElementClientDependencyMatch newEmptyMatch() {
    return NamedElementClientDependencyMatch.newEmptyMatch();
  }
  
  @Override
  public NamedElementClientDependencyMatch newMatch(final Object... parameters) {
    return NamedElementClientDependencyMatch.newMatch((org.eclipse.uml2.uml.NamedElement) parameters[0], (org.eclipse.uml2.uml.Dependency) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static NamedElementClientDependencyQuerySpecification INSTANCE = make();
    
    public static NamedElementClientDependencyQuerySpecification make() {
      return new NamedElementClientDependencyQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static NamedElementClientDependencyQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.namedElementClientDependency";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","d");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.NamedElement"),new PParameter("d", "org.eclipse.uml2.uml.Dependency"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_d = body.getOrCreateVariableByName("d");
      	PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var_dependency = body.getOrCreateVariableByName("dependency");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_d, "d")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      	new TypeConstraint(body, new FlatTuple(var_d), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency")));
      	new TypeConstraint(body, new FlatTuple(var_d), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency")));
      	new TypeConstraint(body, new FlatTuple(var_d, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency", "client")));
      	new Equality(body, var__virtual_0_, var_namedElement);
      	new Equality(body, var_namedElement, var_self);
      	new TypeConstraint(body, new FlatTuple(var_dependency), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Dependency")));
      	new Equality(body, var_d, var_dependency);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "clientDependency");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
