package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.NamespaceImportedMemberMatch;
import org.eclipse.incquery.uml.derivedfeatures.NamespaceImportedMemberMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageVisibleMemberQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate NamespaceImportedMemberMatcher in a type-safe way.
 * 
 * @see NamespaceImportedMemberMatcher
 * @see NamespaceImportedMemberMatch
 * 
 */
@SuppressWarnings("all")
public final class NamespaceImportedMemberQuerySpecification extends BaseGeneratedEMFQuerySpecification<NamespaceImportedMemberMatcher> {
  private NamespaceImportedMemberQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static NamespaceImportedMemberQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected NamespaceImportedMemberMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return NamespaceImportedMemberMatcher.on(engine);
  }
  
  @Override
  public NamespaceImportedMemberMatch newEmptyMatch() {
    return NamespaceImportedMemberMatch.newEmptyMatch();
  }
  
  @Override
  public NamespaceImportedMemberMatch newMatch(final Object... parameters) {
    return NamespaceImportedMemberMatch.newMatch((org.eclipse.uml2.uml.Namespace) parameters[0], (org.eclipse.uml2.uml.PackageableElement) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static NamespaceImportedMemberQuerySpecification INSTANCE = make();
    
    public static NamespaceImportedMemberQuerySpecification make() {
      return new NamespaceImportedMemberQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static NamespaceImportedMemberQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.namespaceImportedMember";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("namespace","importedMember");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("namespace", "org.eclipse.uml2.uml.Namespace"),new PParameter("importedMember", "org.eclipse.uml2.uml.PackageableElement"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_namespace = body.getOrCreateVariableByName("namespace");
      	PVariable var_importedMember = body.getOrCreateVariableByName("importedMember");
      	PVariable var_elementImport = body.getOrCreateVariableByName("elementImport");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_namespace, "namespace"),
      				
      		new ExportedParameter(body, var_importedMember, "importedMember")
      	));
      	new TypeConstraint(body, new FlatTuple(var_namespace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace")));
      	new TypeConstraint(body, new FlatTuple(var_importedMember), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
      	new TypeConstraint(body, new FlatTuple(var_namespace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace")));
      	new TypeConstraint(body, new FlatTuple(var_namespace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace", "elementImport")));
      	new Equality(body, var__virtual_0_, var_elementImport);
      	new TypeConstraint(body, new FlatTuple(var_elementImport), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ElementImport")));
      	new TypeConstraint(body, new FlatTuple(var_elementImport, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ElementImport", "importedElement")));
      	new Equality(body, var__virtual_1_, var_importedMember);
      	bodies.add(body);
      }
      {
      	PBody body = new PBody(this);
      	PVariable var_namespace = body.getOrCreateVariableByName("namespace");
      	PVariable var_importedMember = body.getOrCreateVariableByName("importedMember");
      	PVariable var_packageImport = body.getOrCreateVariableByName("packageImport");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var_importedPackage = body.getOrCreateVariableByName("importedPackage");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_namespace, "namespace"),
      				
      		new ExportedParameter(body, var_importedMember, "importedMember")
      	));
      	new TypeConstraint(body, new FlatTuple(var_namespace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace")));
      	new TypeConstraint(body, new FlatTuple(var_importedMember), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
      	new TypeConstraint(body, new FlatTuple(var_namespace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace")));
      	new TypeConstraint(body, new FlatTuple(var_namespace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace", "packageImport")));
      	new Equality(body, var__virtual_0_, var_packageImport);
      	new TypeConstraint(body, new FlatTuple(var_packageImport), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageImport")));
      	new TypeConstraint(body, new FlatTuple(var_packageImport, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageImport", "importedPackage")));
      	new Equality(body, var__virtual_1_, var_importedPackage);
      	new PositivePatternCall(body, new FlatTuple(var_importedPackage, var_importedMember), PackageVisibleMemberQuerySpecification.instance().getInternalQueryRepresentation());
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "importedMember");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
