package org.eclipse.incquery.viewers.runtime.model.patterns.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2itemMatch;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2itemMatcher;

/**
 * A pattern-specific query specification that can instantiate Param2itemMatcher in a type-safe way.
 * 
 * @see Param2itemMatcher
 * @see Param2itemMatch
 * 
 */
@SuppressWarnings("all")
public final class Param2itemQuerySpecification extends BaseGeneratedEMFQuerySpecification<Param2itemMatcher> {
  private Param2itemQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static Param2itemQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected Param2itemMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return Param2itemMatcher.on(engine);
  }
  
  @Override
  public Param2itemMatch newEmptyMatch() {
    return Param2itemMatch.newEmptyMatch();
  }
  
  @Override
  public Param2itemMatch newMatch(final Object... parameters) {
    return Param2itemMatch.newMatch((java.lang.Object) parameters[0], (org.eclipse.incquery.viewmodel.traceability.Trace) parameters[1], (org.eclipse.incquery.viewers.runtime.model.Item) parameters[2]);
  }
  
  private static class LazyHolder {
    private final static Param2itemQuerySpecification INSTANCE = make();
    
    public static Param2itemQuerySpecification make() {
      return new Param2itemQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static Param2itemQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.viewers.runtime.model.patterns.param2item";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("param","trace","item");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("param", "java.lang.Object"),new PParameter("trace", "org.eclipse.incquery.viewmodel.traceability.Trace"),new PParameter("item", "org.eclipse.incquery.viewers.runtime.model.Item"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_param = body.getOrCreateVariableByName("param");
      	PVariable var_trace = body.getOrCreateVariableByName("trace");
      	PVariable var_item = body.getOrCreateVariableByName("item");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_param, "param"),
      				
      		new ExportedParameter(body, var_trace, "trace"),
      				
      		new ExportedParameter(body, var_item, "item")
      	));
      	new TypeUnary(body, var_trace, getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace");
      	new TypeUnary(body, var_item, getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Item"), "http://org.eclipse.incquery/viewmodel/notation/1.0/Item");
      	new TypeUnary(body, var_trace, getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace");
      	new TypeBinary(body, CONTEXT, var_trace, var__virtual_0_, getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "params"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace.params");
      	new Equality(body, var__virtual_0_, var_param);
      	new TypeUnary(body, var_trace, getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace");
      	new TypeBinary(body, CONTEXT, var_trace, var__virtual_1_, getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "targets"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace.targets");
      	new Equality(body, var__virtual_1_, var_item);
      	bodies.add(body);
      }
      {
      	PBody body = new PBody(this);
      	PVariable var_param = body.getOrCreateVariableByName("param");
      	PVariable var_trace = body.getOrCreateVariableByName("trace");
      	PVariable var_item = body.getOrCreateVariableByName("item");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_param, "param"),
      				
      		new ExportedParameter(body, var_trace, "trace"),
      				
      		new ExportedParameter(body, var_item, "item")
      	));
      	new TypeUnary(body, var_trace, getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace");
      	new TypeUnary(body, var_item, getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Item"), "http://org.eclipse.incquery/viewmodel/notation/1.0/Item");
      	new TypeUnary(body, var_trace, getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace");
      	new TypeBinary(body, CONTEXT, var_trace, var__virtual_0_, getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "objects"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace.objects");
      	new Equality(body, var__virtual_0_, var_param);
      	new TypeUnary(body, var_trace, getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace");
      	new TypeBinary(body, CONTEXT, var_trace, var__virtual_1_, getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "targets"), "http://org.eclipse.incquery/viewmodel/traceability/1.0/Trace.targets");
      	new Equality(body, var__virtual_1_, var_item);
      	bodies.add(body);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
