/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.zest.sources;

import com.google.common.base.Preconditions;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.AbstractViewerStateListener;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerStateListener;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractZestContentProvider
extends AbstractViewerStateListener {
    protected GraphViewer viewer;
    protected ViewerState state;
    protected boolean displayContainment;

    public AbstractZestContentProvider() {
        this(false);
    }

    public AbstractZestContentProvider(boolean displayContainment) {
        this.displayContainment = displayContainment;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof GraphViewer));
        this.viewer = (GraphViewer)viewer;
        if (oldInput instanceof ViewerState) {
            ((ViewerState)oldInput).removeStateListener((IViewerStateListener)this);
        }
        if (newInput == null) {
            this.state = null;
        } else if (newInput instanceof ViewerState) {
            this.state = (ViewerState)newInput;
            this.state.addStateListener((IViewerStateListener)this);
        } else {
            throw new IllegalArgumentException(String.format("Invalid input type %s for Zest Viewer.", newInput.getClass().getName()));
        }
    }

    public void itemAppeared(Item item) {
        this.viewer.addNode((Object)item);
    }

    public void itemDisappeared(Item item) {
        this.viewer.removeNode((Object)item);
    }

    public void containmentAppeared(Containment containment) {
        if (this.displayContainment) {
            this.edgeAppeared((Edge)containment);
        }
    }

    public void containmentDisappeared(Containment containment) {
        if (this.displayContainment) {
            this.edgeDisappeared((Edge)containment);
        }
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removeStateListener((IViewerStateListener)this);
        }
    }
}

