/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.validators;

import com.google.inject.Inject;
import org.eclipse.incquery.patternlanguage.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.incquery.patternlanguage.emf.annotations.AnnotationExpressionValidator;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.validation.IIssueCallback;

public abstract class AbstractAnnotationValidator
implements IPatternAnnotationAdditionalValidator {
    protected static final String VALIDATOR_BASE_CODE = "org.eclipse.incquery.viewers.";
    public static final String GENERAL_ISSUE_CODE = "org.eclipse.incquery.viewers.general";
    public static final String EXPRESSION_MISMATCH_ISSUE_CODE = "org.eclipse.incquery.viewers.expressionmismatch";
    @Inject
    private AnnotationExpressionValidator expressionValidator;

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        Pattern pattern = (Pattern)annotation.eContainer();
        ValueReference labelRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"label");
        if (labelRef instanceof StringValue) {
            String value = ((StringValue)labelRef).getValue();
            this.expressionValidator.validateStringExpression(value, pattern, labelRef, validator);
        }
    }
}

