/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.extensions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionHelper {
    public Set<ISelectionChangedListener> selectionChangedListeners = Sets.newHashSet();
    public ISelectionChangedListener trickyListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            for (ISelectionChangedListener l : SelectionHelper.this.selectionChangedListeners) {
                l.selectionChanged(new SelectionChangedEvent(event.getSelectionProvider(), SelectionHelper.this.unwrapElements_ViewersElementsToEObjects(event.getSelection())));
            }
        }
    };

    private Object getSourceObject(Item i) {
        if (i.getParamEObject() != null) {
            return i.getParamEObject();
        }
        if (i.getParamObject() != null) {
            return i.getParamObject();
        }
        throw new IllegalStateException("Invalid Item selected - no source model element available.");
    }

    public ISelection unwrapElements_ViewersElementsToEObjects(ISelection sel) {
        ArrayList proxy = Lists.newArrayList();
        if (sel instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)sel).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                if (e instanceof Item) {
                    proxy.add(this.getSourceObject((Item)e));
                } else if (e instanceof Edge) {
                    proxy.add(this.getSourceObject(((Edge)e).getSource()));
                    proxy.add(this.getSourceObject(((Edge)e).getTarget()));
                }
                ++n2;
            }
        }
        return new StructuredSelection((List)proxy);
    }

    public ISelection unwrapElements_EObjectsToViewersElements(ISelection sel, ViewerState state) {
        ArrayList proxy = Lists.newArrayList();
        if (state != null && sel instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)sel).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                if (e instanceof EObject) {
                    proxy.addAll(state.getItemsFor(e));
                }
                ++n2;
            }
        }
        return new StructuredSelection((List)proxy);
    }
}

