/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.internal.dot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

final class DotDrawer {
    private DotDrawer() {
    }

    static File renderImage(File dotExecutableDir, File dotInputFile, String format, String imageResultFile) {
        String outputFormat = "-T" + format;
        String resultFile = imageResultFile == null ? String.valueOf(dotInputFile.getName()) + "." + format : imageResultFile;
        String dotFile = dotInputFile.getName();
        String inputFolder = String.valueOf(new File(dotInputFile.getParent()).getAbsolutePath()) + File.separator;
        String outputFolder = imageResultFile == null ? inputFolder : String.valueOf(new File(new File(imageResultFile).getAbsolutePath()).getParentFile().getAbsolutePath()) + File.separator;
        String dotExecutable = "dot" + (DotDrawer.runningOnWindows() ? ".exe" : "");
        String[] commands = new String[]{String.valueOf(dotExecutableDir.getAbsolutePath()) + File.separator + dotExecutable, outputFormat, "-o", String.valueOf(outputFolder) + resultFile, String.valueOf(inputFolder) + dotFile};
        DotDrawer.call(commands);
        return new File(outputFolder, resultFile);
    }

    private static void call(String[] commands) {
        System.out.print("Calling: " + Arrays.asList(commands));
        Runtime runtime = Runtime.getRuntime();
        Process p = null;
        try {
            p = runtime.exec(commands);
            p.waitFor();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        System.out.println(", resulted in exit status: " + p.exitValue());
        String errors = DotDrawer.read(p.getErrorStream());
        String output = DotDrawer.read(p.getInputStream());
        if (errors.trim().length() > 0) {
            System.err.println("Errors from dot call: " + errors);
        }
        if (output.trim().length() > 0) {
            System.out.println("Output from dot call: " + output);
        }
    }

    private static String read(InputStream s) {
        StringBuilder builder = new StringBuilder();
        try {
            int current = -1;
            while ((current = s.read()) != -1) {
                builder.append((char)current);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    private static boolean runningOnWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }
}

