/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.internal.dot;

import java.io.File;
import java.util.Scanner;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.internal.dot.DotDrawer;
import org.eclipse.gef4.zest.internal.dot.DotFileUtils;
import org.eclipse.gef4.zest.internal.dot.DotTemplate;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public final class DotExport {
    public static final String DOT_BIN_DIR_KEY = "org.eclipse.gef4.zest.dot.bin.dir";
    private static final String DEFAULT_OUTPUT_FORMAT = "pdf";
    private String dotString;
    private String graphName = "Unnamed" + System.currentTimeMillis();
    private Graph graph;

    public DotExport(Graph graph) {
        this.dotString = DotExport.graphToDot(graph);
        this.graphName = graph.getClass().getSimpleName();
        this.graph = graph;
    }

    public DotExport(String dotString) {
        this.dotString = dotString;
    }

    public String toDotString() {
        return this.dotString;
    }

    public File toDotFile(File destination) {
        DotFileUtils.write(this.dotString, destination);
        return destination;
    }

    public File toImage(String dotBinDir, String resultFile) {
        return this.toImage(dotBinDir, resultFile == null ? DEFAULT_OUTPUT_FORMAT : resultFile.substring(resultFile.lastIndexOf(46) + 1), resultFile);
    }

    public File toImage(String resultFile) {
        Rectangle bounds = this.graph.getContents().getBounds();
        org.eclipse.swt.graphics.Point size = new org.eclipse.swt.graphics.Point(this.graph.getContents().getSize().width, this.graph.getContents().getSize().height);
        Point viewLocation = this.graph.getViewport().getViewLocation();
        Image image = new Image(null, size.x, size.y);
        GC gc = new GC((Drawable)image);
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        swtGraphics.translate(-1 * bounds.x + viewLocation.x, -1 * bounds.y + viewLocation.y);
        this.graph.getViewport().paint((Graphics)swtGraphics);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(resultFile, 5);
        return new File(resultFile);
    }

    public File toImage(String dotDir, String format, String resultFile) {
        File dotFile = DotFileUtils.write(this.dotString);
        File image = DotDrawer.renderImage(new File(dotDir), dotFile, format, resultFile);
        return image;
    }

    public String toString() {
        return this.graphName.equals("Graph") ? "Zest" + this.graphName : this.graphName;
    }

    private static String graphToDot(Graph graph) {
        String raw = new DotTemplate().generate(graph);
        raw = DotExport.removeBlankLines(raw);
        return raw;
    }

    private static String removeBlankLines(String raw) {
        Scanner scanner = new Scanner(raw);
        StringBuilder builder = new StringBuilder();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.trim().equals("")) continue;
            builder.append(String.valueOf(line) + "\n");
        }
        return builder.toString();
    }
}

