/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.internal.dot;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.gef4.zest.internal.dot.DotMessages;

public final class DotFileUtils {
    private DotFileUtils() {
    }

    public static File resolve(URL url) {
        File resultFile = null;
        URL resolved = url;
        if (!url.getProtocol().equals("file")) {
            try {
                resolved = FileLocator.resolve((URL)resolved);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            resultFile = new File(resolved.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return resultFile;
    }

    public static File write(String text) {
        try {
            return DotFileUtils.write(text, File.createTempFile("zest", ".dot"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File write(String text, File destination) {
        try {
            FileWriter writer = new FileWriter(destination);
            writer.write(text);
            writer.flush();
            writer.close();
            return destination;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String read(File file) {
        StringBuilder builder = new StringBuilder();
        try {
            Scanner s = new Scanner(file);
            while (s.hasNextLine()) {
                builder.append(s.nextLine()).append("\n");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyAllFiles(File sourceRootFolder, File destinationRootFolder) {
        String[] stringArray = sourceRootFolder.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File source = new File(sourceRootFolder, name);
            if (!source.getName().equals("CVS")) {
                if (source.isDirectory()) {
                    File destinationFolder = new File(destinationRootFolder, source.getName());
                    if (!destinationFolder.mkdirs() && !destinationFolder.exists()) {
                        throw new IllegalStateException(String.valueOf(DotMessages.DotFileUtils_0) + ": " + destinationFolder);
                    }
                    DotFileUtils.copyAllFiles(source, destinationFolder);
                } else {
                    DotFileUtils.copySingleFile(destinationRootFolder, name, source);
                }
            }
            ++n2;
        }
    }

    public static File copySingleFile(File destinationFolder, String newFileName, File sourceFile) {
        File destinationFile;
        block7: {
            destinationFile = new File(destinationFolder, newFileName);
            InputStream sourceStream = null;
            FileOutputStream destinationStream = null;
            try {
                int bytesRead;
                sourceStream = sourceFile.toURI().toURL().openStream();
                destinationStream = new FileOutputStream(destinationFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = sourceStream.read(buffer)) != -1) {
                    destinationStream.write(buffer, 0, bytesRead);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                DotFileUtils.close(sourceStream);
                DotFileUtils.close(destinationStream);
                break block7;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DotFileUtils.close(sourceStream);
                    DotFileUtils.close(destinationStream);
                    throw throwable;
                }
                DotFileUtils.close(sourceStream);
                DotFileUtils.close(destinationStream);
                break block7;
            }
            DotFileUtils.close(sourceStream);
            DotFileUtils.close(destinationStream);
        }
        return destinationFile;
    }
}

