/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.internal.dot;

import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphContainer;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;

public class DotTemplate {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "";
    protected final String TEXT_2 = this.NL;
    protected final String TEXT_3 = " ";
    protected final String TEXT_4 = "{" + this.NL + this.NL + "\t/* Global settings */" + this.NL + "\tgraph[layout=";
    protected final String TEXT_5 = "]" + this.NL + "\tnode[shape=box] //more like the Zest default node look" + this.NL + "\trankdir=";
    protected final String TEXT_6 = String.valueOf(this.NL) + "\t" + this.NL + "\t/* Nodes */" + this.NL + "\t";
    protected final String TEXT_7 = " " + this.NL + "\t";
    protected final String TEXT_8 = "[label=\"";
    protected final String TEXT_9 = "\"];";
    protected final String TEXT_10 = String.valueOf(this.NL) + "\t";
    protected final String TEXT_11 = " " + this.NL + "\t  ";
    protected final String TEXT_12 = " ";
    protected final String TEXT_13 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_14 = "[label=\"";
    protected final String TEXT_15 = "\"];";
    protected final String TEXT_16 = String.valueOf(this.NL) + "\t";
    protected final String TEXT_17 = String.valueOf(this.NL) + "\t";
    protected final String TEXT_18 = String.valueOf(this.NL) + "\t" + this.NL + "\t/* Edges */" + this.NL + "\t";
    protected final String TEXT_19 = " " + this.NL + "\t";
    protected final String TEXT_20 = " " + this.NL + "\t";
    protected final String TEXT_21 = " ";
    protected final String TEXT_22 = " ";
    protected final String TEXT_23 = "[style=";
    protected final String TEXT_24 = " label=\"";
    protected final String TEXT_25 = "\"];" + this.NL + "\t";
    protected final String TEXT_26 = String.valueOf(this.NL) + "}";

    public static synchronized DotTemplate create(String lineSeparator) {
        nl = lineSeparator;
        DotTemplate result = new DotTemplate();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Graph graph = (Graph)argument;
        boolean small = graph.getNodes().size() < 100;
        LayoutAlgorithm algo = graph.getLayoutAlgorithm() != null ? graph.getLayoutAlgorithm() : new TreeLayoutAlgorithm();
        boolean digraph = graph.getConnectionStyle() == 2;
        String simpleClassName = graph.getClass().getSimpleName();
        simpleClassName = simpleClassName.equals("Graph") ? "Zest" + simpleClassName : simpleClassName;
        stringBuffer.append("");
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(digraph ? "digraph" : "graph");
        stringBuffer.append(" ");
        stringBuffer.append(simpleClassName);
        stringBuffer.append(this.TEXT_4);
        stringBuffer.append(algo.getClass() == RadialLayoutAlgorithm.class ? "twopi" : (algo.getClass() == GridLayoutAlgorithm.class ? "osage" : (algo.getClass() == SpringLayoutAlgorithm.class ? (small ? "fdp" : "sfdp") : "dot")));
        stringBuffer.append(this.TEXT_5);
        stringBuffer.append(graph.getLayoutAlgorithm() != null && graph.getLayoutAlgorithm().getClass() == TreeLayoutAlgorithm.class && ((TreeLayoutAlgorithm)graph.getLayoutAlgorithm()).getDirection() == 3 ? "LR" : "TD");
        stringBuffer.append(this.TEXT_6);
        for (Object nodeObject : graph.getNodes()) {
            GraphNode node = (GraphNode)nodeObject;
            stringBuffer.append(this.TEXT_7);
            if (!(node instanceof GraphContainer)) {
                stringBuffer.append(node.hashCode());
                stringBuffer.append("[label=\"");
                stringBuffer.append(node.getText());
                stringBuffer.append("\"];");
            }
            stringBuffer.append(this.TEXT_10);
            if (node instanceof GraphContainer) {
                stringBuffer.append(this.TEXT_11);
                for (Object o : ((GraphContainer)node).getNodes()) {
                    GraphNode n = (GraphNode)o;
                    stringBuffer.append(" ");
                    stringBuffer.append(this.TEXT_13);
                    stringBuffer.append(n.hashCode());
                    stringBuffer.append("[label=\"");
                    stringBuffer.append(n.getText());
                    stringBuffer.append("\"];");
                }
                stringBuffer.append(this.TEXT_16);
            }
            stringBuffer.append(this.TEXT_17);
        }
        stringBuffer.append(this.TEXT_18);
        for (Object edgeObject : graph.getConnections()) {
            GraphConnection edge = (GraphConnection)edgeObject;
            stringBuffer.append(this.TEXT_19);
            boolean dashed = edge.getLineStyle() == 2;
            boolean dotted = edge.getLineStyle() == 3;
            stringBuffer.append(this.TEXT_20);
            stringBuffer.append(edge.getSource().hashCode());
            stringBuffer.append(" ");
            stringBuffer.append(digraph ? "->" : "--");
            stringBuffer.append(" ");
            stringBuffer.append(edge.getDestination().hashCode());
            stringBuffer.append("[style=");
            stringBuffer.append(dashed ? "dashed" : (dotted ? "dotted" : "solid"));
            stringBuffer.append(" label=\"");
            stringBuffer.append(edge.getText());
            stringBuffer.append(this.TEXT_25);
        }
        stringBuffer.append(this.TEXT_26);
        return stringBuffer.toString();
    }
}

