/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.viewers.internal;

import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef4.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.gef4.zest.core.viewers.IEntityConnectionStyleProvider;
import org.eclipse.gef4.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.gef4.zest.core.viewers.ISelfStyleProvider;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.ZestStyles;
import org.eclipse.gef4.zest.core.widgets.decoration.IConnectionDecorator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;

public class GraphItemStyler {
    public static void styleItem(GraphItem item, IBaseLabelProvider labelProvider) {
        if (item instanceof GraphNode) {
            GraphNode node = (GraphNode)item;
            if (node.getGraphModel().getNodeStyle() != 0) {
                node.setNodeStyle(node.getGraphModel().getNodeStyle());
            } else {
                node.setNodeStyle(0);
            }
            Object entity = node.getData();
            if (labelProvider instanceof IEntityStyleProvider) {
                GraphItemStyler.styleNode(node, (IEntityStyleProvider)labelProvider);
            }
            if (labelProvider instanceof IColorProvider) {
                IColorProvider colorProvider = (IColorProvider)labelProvider;
                node.setForegroundColor(colorProvider.getForeground(entity));
                node.setBackgroundColor(colorProvider.getBackground(entity));
            }
            if (labelProvider instanceof IFontProvider) {
                IFontProvider fontProvider = (IFontProvider)labelProvider;
                node.setFont(fontProvider.getFont(entity));
            }
            if (labelProvider instanceof ILabelProvider) {
                String text = ((ILabelProvider)labelProvider).getText(node.getData());
                node.setText(text != null ? text : "");
                node.setImage(((ILabelProvider)labelProvider).getImage(node.getData()));
            }
            if (labelProvider instanceof ISelfStyleProvider) {
                ((ISelfStyleProvider)labelProvider).selfStyleNode(entity, node);
            }
        } else if (item instanceof GraphConnection) {
            GraphConnection conn = (GraphConnection)item;
            if (conn.getGraphModel().getConnectionStyle() != 0) {
                int s = conn.getGraphModel().getConnectionStyle();
                conn.setConnectionStyle(s);
            } else {
                conn.setConnectionStyle(0);
            }
            if (labelProvider instanceof ILabelProvider) {
                String text = ((ILabelProvider)labelProvider).getText(conn.getData());
                conn.setText(text != null ? text : "");
                conn.setImage(((ILabelProvider)labelProvider).getImage(conn.getData()));
            }
            if (labelProvider instanceof IEntityConnectionStyleProvider) {
                GraphItemStyler.styleEntityConnection(conn, (IEntityConnectionStyleProvider)labelProvider);
            } else if (labelProvider instanceof IConnectionStyleProvider) {
                GraphItemStyler.styleConnection(conn, (IConnectionStyleProvider)labelProvider);
            }
            int swt = GraphItemStyler.getLineStyleForZestStyle(conn.getConnectionStyle());
            conn.setLineStyle(swt);
            if (labelProvider instanceof ISelfStyleProvider) {
                ((ISelfStyleProvider)labelProvider).selfStyleConnection(conn.getData(), conn);
            }
        }
    }

    private static void styleConnection(GraphConnection conn, IConnectionStyleProvider provider) {
        IConnectionDecorator decorator;
        ConnectionRouter cr;
        IFigure tooltip;
        Color c;
        Object rel = conn.getData();
        int style = provider.getConnectionStyle(rel);
        if (!ZestStyles.validateConnectionStyle((int)style)) {
            throw new SWTError(5);
        }
        if (style != 0) {
            conn.setConnectionStyle(style);
        }
        if ((c = provider.getHighlightColor(rel)) != null) {
            conn.setHighlightColor(c);
        }
        if ((c = provider.getColor(rel)) != null) {
            conn.setLineColor(c);
        }
        if ((tooltip = provider.getTooltip(rel)) != null) {
            conn.setTooltip(tooltip);
        }
        int w = -1;
        w = provider.getLineWidth(rel);
        if (w >= 0) {
            conn.setLineWidth(w);
        }
        if ((cr = provider.getRouter(rel)) != null) {
            conn.setRouter(cr);
        }
        if ((decorator = provider.getConnectionDecorator(rel)) != null) {
            conn.setConnectionDecoration(decorator);
        }
    }

    private static void styleEntityConnection(GraphConnection conn, IEntityConnectionStyleProvider provider) {
        ConnectionRouter cr;
        Color c;
        Object dest;
        Object src = conn.getSource().getData();
        int style = provider.getConnectionStyle(src, dest = conn.getDestination().getData());
        if (!ZestStyles.validateConnectionStyle((int)style)) {
            throw new SWTError(5);
        }
        if (style != 0) {
            conn.setConnectionStyle(style);
        }
        if ((c = provider.getColor(src, dest)) != null) {
            conn.setLineColor(c);
        }
        if ((c = provider.getHighlightColor(src, dest)) != null) {
            conn.setHighlightColor(c);
        }
        int w = -1;
        w = provider.getLineWidth(src, dest);
        if (w >= 0) {
            conn.setLineWidth(w);
        }
        if ((cr = provider.getRouter(src, dest)) != null) {
            conn.setRouter(cr);
        }
    }

    private static void styleNode(GraphNode node, IEntityStyleProvider provider) {
        IFigure figure;
        Color c;
        Object entity = node.getData();
        int width = -1;
        if (provider.fisheyeNode(entity)) {
            node.setNodeStyle(node.getNodeStyle() | 4);
        }
        if ((c = provider.getBorderColor(entity)) != null) {
            node.setBorderColor(c);
        }
        if ((c = provider.getBorderHighlightColor(entity)) != null) {
            node.setBorderHighlightColor(c);
        }
        if ((c = provider.getNodeHighlightColor(entity)) != null) {
            node.setHighlightColor(c);
        }
        if ((c = provider.getBackgroundColour(entity)) != null) {
            node.setBackgroundColor(c);
        }
        if ((c = provider.getForegroundColour(entity)) != null) {
            node.setForegroundColor(c);
        }
        if ((width = provider.getBorderWidth(entity)) >= 0) {
            node.setBorderWidth(width);
        }
        if ((figure = provider.getTooltip(entity)) != null) {
            node.setTooltip(figure);
        }
    }

    public static int getLineStyleForZestStyle(int style) {
        int lineStyles = 60;
        if ((style &= lineStyles) == 0) {
            style = 4;
        }
        switch (style) {
            case 32: {
                return 4;
            }
            case 8: {
                return 2;
            }
            case 16: {
                return 3;
            }
        }
        return 1;
    }
}

