/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.itc.alg.incscc;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.UnionFindNodeProperty;

public class UnionFind<V> {
    public Map<V, UnionFindNodeProperty<V>> nodeMap = new HashMap<V, UnionFindNodeProperty<V>>();
    public Map<V, Set<V>> setMap = new HashMap<V, Set<V>>();

    public V makeSet(V[] nodes) {
        if (nodes.length > 1) {
            V root = this.makeSet(nodes[0]);
            int i = 1;
            while (i < nodes.length) {
                root = this.union(nodes[i], root);
                ++i;
            }
            return root;
        }
        if (nodes.length == 1) {
            return this.makeSet(nodes[0]);
        }
        return null;
    }

    public V makeSet(Collection<V> nodes) {
        if (nodes.size() > 1) {
            V root = this.makeSet(nodes.iterator().next());
            for (V node : nodes) {
                root = this.union(node, root);
            }
            return root;
        }
        if (nodes.size() == 1) {
            return this.makeSet(nodes.iterator().next());
        }
        return null;
    }

    public V makeSet(V node) {
        if (!this.nodeMap.containsKey(node)) {
            UnionFindNodeProperty<V> prop = new UnionFindNodeProperty<V>(0, node);
            this.nodeMap.put((UnionFindNodeProperty<V>)node, (UnionFindNodeProperty<UnionFindNodeProperty<V>>)prop);
            HashSet<V> set = new HashSet<V>();
            set.add(node);
            this.setMap.put(node, set);
        }
        return node;
    }

    public V find(V node) {
        UnionFindNodeProperty<V> prop = this.nodeMap.get(node);
        if (prop != null) {
            if (prop.parent.equals(node)) {
                return node;
            }
            prop.parent = this.find(prop.parent);
            return prop.parent;
        }
        return null;
    }

    public V union(V x, V y) {
        V xRoot = this.find(x);
        V yRoot = this.find(y);
        if (xRoot == null && yRoot == null) {
            this.makeSet(x);
            this.makeSet(y);
            return this.union(x, y);
        }
        if (xRoot != null && yRoot == null) {
            this.makeSet(y);
            return this.union(x, y);
        }
        if (xRoot == null && yRoot != null) {
            this.makeSet(x);
            return this.union(x, y);
        }
        if (xRoot != null && yRoot != null && !xRoot.equals(yRoot)) {
            UnionFindNodeProperty<V> xRootProp = this.nodeMap.get(xRoot);
            UnionFindNodeProperty<V> yRootProp = this.nodeMap.get(yRoot);
            if (xRootProp.rank < yRootProp.rank) {
                xRootProp.parent = yRoot;
                this.setMap.get(yRoot).addAll((Collection)this.setMap.get(xRoot));
                this.setMap.remove(xRoot);
                return yRoot;
            }
            if (xRootProp.rank > yRootProp.rank) {
                yRootProp.parent = xRoot;
                this.setMap.get(xRoot).addAll((Collection)this.setMap.get(yRoot));
                this.setMap.remove(yRoot);
                return xRoot;
            }
            yRootProp.parent = xRoot;
            ++xRootProp.rank;
            this.setMap.get(xRoot).addAll((Collection)this.setMap.get(yRoot));
            this.setMap.remove(yRoot);
            return xRoot;
        }
        return xRoot;
    }

    public void deleteSet(V root) {
        for (V n : this.setMap.get(root)) {
            this.nodeMap.remove(n);
        }
        this.setMap.remove(root);
    }
}

