/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.base.api.QueryResultAssociativeStore;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.Direction;

public abstract class QueryResultMap<KeyType, ValueType>
extends QueryResultAssociativeStore<KeyType, ValueType>
implements Map<KeyType, ValueType> {
    private Map<KeyType, ValueType> cache = new HashMap<KeyType, ValueType>();

    protected QueryResultMap(Logger logger) {
        this.setLogger(logger);
    }

    @Override
    protected Collection<Map.Entry<KeyType, ValueType>> getCacheEntries() {
        return this.cache.entrySet();
    }

    @Override
    protected boolean internalCachePut(KeyType key, ValueType value) {
        ValueType put = this.cache.put(key, value);
        if (put == null) {
            return value != null;
        }
        return !put.equals(value);
    }

    @Override
    protected boolean internalCacheRemove(KeyType key, ValueType value) {
        ValueType remove = this.cache.remove(key);
        return remove != null;
    }

    @Override
    protected int internalCacheSize() {
        return this.cache.size();
    }

    @Override
    protected boolean internalCacheContainsEntry(KeyType key, ValueType value) {
        return this.cache.get(key).equals(value);
    }

    protected Map<KeyType, ValueType> getCache() {
        return this.cache;
    }

    protected void setCache(Map<KeyType, ValueType> cache) {
        this.cache = cache;
    }

    @Override
    public void clear() {
        this.internalClear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<KeyType, ValueType>> entrySet() {
        return Collections.unmodifiableSet((Set)this.getCacheEntries());
    }

    @Override
    public ValueType get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Set<KeyType> keySet() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    @Override
    public ValueType put(KeyType key, ValueType value) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        ValueType oldValue = this.cache.get(key);
        boolean modified = this.modifyThroughQueryResultSetter(key, value, Direction.INSERT);
        return (ValueType)(modified ? oldValue : null);
    }

    @Override
    public void putAll(Map<? extends KeyType, ? extends ValueType> map) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        for (Map.Entry<KeyType, ValueType> entry : map.entrySet()) {
            this.modifyThroughQueryResultSetter(entry.getKey(), entry.getValue(), Direction.INSERT);
        }
    }

    @Override
    public ValueType remove(Object key) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        if (this.cache.containsKey(key)) {
            ValueType value = this.cache.get(key);
            this.modifyThroughQueryResultSetter(key, value, Direction.DELETE);
            return value;
        }
        return null;
    }

    @Override
    public int size() {
        return this.internalCacheSize();
    }

    @Override
    public Collection<ValueType> values() {
        return Collections.unmodifiableCollection(this.cache.values());
    }
}

