/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.base.Preconditions;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.event.AbstractRuleInstanceBuilder;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.event.EventRealm;
import org.eclipse.incquery.runtime.evm.api.event.EventSourceSpecification;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventFilter;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryRuleInstanceBuilder;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public class IncQueryEventSourceSpecification<Match extends IPatternMatch>
implements EventSourceSpecification<Match> {
    private IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification;
    private final EventFilter<Match> EMPTY_FILTER = new EventFilter<Match>(){

        @Override
        public boolean isProcessable(Match eventAtom) {
            return true;
        }
    };

    protected IncQueryEventSourceSpecification(IQuerySpecification<? extends IncQueryMatcher<Match>> factory) {
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)"Cannot create source definition for null querySpecification!");
        this.querySpecification = factory;
    }

    public EventFilter<Match> createFilter(Match eventAtom) {
        Preconditions.checkArgument((eventAtom != null ? 1 : 0) != 0, (Object)"Cannot create filter for null match, use createEmptyFilter() instead!");
        Preconditions.checkArgument((!eventAtom.isMutable() ? 1 : 0) != 0, (Object)"Cannot create filter for mutable match!");
        if (IncQueryEventRealm.isEmpty(eventAtom)) {
            return this.EMPTY_FILTER;
        }
        return new IncQueryEventFilter<Match>(eventAtom);
    }

    @Override
    public EventFilter<Match> createEmptyFilter() {
        return this.EMPTY_FILTER;
    }

    public IQuerySpecification<? extends IncQueryMatcher<Match>> getQuerySpecification() {
        return this.querySpecification;
    }

    protected IncQueryMatcher<Match> getMatcher(IncQueryEngine engine) throws IncQueryException {
        IncQueryMatcher matcher = this.querySpecification.getMatcher(engine);
        return matcher;
    }

    @Override
    public AbstractRuleInstanceBuilder<Match> getRuleInstanceBuilder(EventRealm realm) {
        return new IncQueryRuleInstanceBuilder((IncQueryEventRealm)realm, this);
    }
}

