/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.job;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;

public class StatelessJob<Match extends IPatternMatch>
extends Job<Match> {
    private IMatchProcessor<Match> matchProcessor;

    public IMatchProcessor<Match> getMatchProcessor() {
        return this.matchProcessor;
    }

    public StatelessJob(IncQueryActivationStateEnum incQueryActivationStateEnum, IMatchProcessor<Match> matchProcessor) {
        super(incQueryActivationStateEnum);
        this.matchProcessor = (IMatchProcessor)Preconditions.checkNotNull(matchProcessor, (Object)"StatelessJob cannot be instantiated with null match processor");
    }

    @Override
    protected void execute(Activation<? extends Match> activation, Context context) {
        this.matchProcessor.process((IPatternMatch)activation.getAtom());
    }

    @Override
    protected void handleError(Activation<? extends Match> activation, Exception exception, Context context) {
        Preconditions.checkState((boolean)false, (Object)("Exception " + exception.getMessage() + " was thrown when executing " + activation + "! Stateless job doesn't handle errors!" + Arrays.toString(exception.getStackTrace())));
    }
}

