/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.qrm;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.base.api.QueryResultMultimap;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Lifecycles;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.job.StatelessJob;

public abstract class EVMBasedQueryResultMultimap<Match extends IPatternMatch, KeyType, ValueType>
extends QueryResultMultimap<KeyType, ValueType> {
    private final Set<Job<Match>> jobs;
    private final ExecutionSchema schema;

    protected EVMBasedQueryResultMultimap(ExecutionSchema schema) {
        super(Logger.getLogger(EVMBasedQueryResultMultimap.class));
        this.schema = schema;
        this.jobs = new HashSet<Job<Match>>();
        this.jobs.add(new StatelessJob(IncQueryActivationStateEnum.APPEARED, new IMatchProcessor<Match>(){

            public void process(Match match) {
                Object key = EVMBasedQueryResultMultimap.this.getKeyFromMatch(match);
                Object value = EVMBasedQueryResultMultimap.this.getValueFromMatch(match);
                EVMBasedQueryResultMultimap.this.internalPut(key, value);
            }
        }));
        this.jobs.add(new StatelessJob(IncQueryActivationStateEnum.DISAPPEARED, new IMatchProcessor<Match>(){

            public void process(Match match) {
                Object key = EVMBasedQueryResultMultimap.this.getKeyFromMatch(match);
                Object value = EVMBasedQueryResultMultimap.this.getValueFromMatch(match);
                EVMBasedQueryResultMultimap.this.internalRemove(key, value);
            }
        }));
    }

    protected EVMBasedQueryResultMultimap(IncQueryEngine engine) {
        this(ExecutionSchemas.createIncQueryExecutionSchema(engine, Schedulers.getIQEngineSchedulerFactory(engine)));
    }

    public <Matcher extends IncQueryMatcher<Match>> void addMatcherToMultimapResults(IQuerySpecification<Matcher> querySpecification) {
        this.schema.addRule(Rules.newMatcherRuleSpecification(querySpecification, Lifecycles.getDefault(false, true), this.jobs));
    }

    protected abstract KeyType getKeyFromMatch(Match var1);

    protected abstract ValueType getValueFromMatch(Match var1);
}

