/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.incquery.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;

public class PBodyNormalizer
extends PDisjunctionRewriter {
    public static final boolean calcImpliedTypes = true;
    private IPatternMatcherContext context;

    public PBodyNormalizer(IPatternMatcherContext context) {
        this.context = context;
    }

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        Preconditions.checkArgument((boolean)disjunction.isMutable(), (Object)"Disjunction must be mutable");
        try {
            for (PBody body : disjunction.getBodies()) {
                this.normalizeBody(body);
            }
        }
        catch (QueryPlannerException e) {
            throw new RewriterException("Error during rewriting: {1}", new String[]{e.getMessage()}, e.getShortMessage(), disjunction.getQuery(), e);
        }
        return disjunction;
    }

    public void setContext(IPatternMatcherContext context) {
        this.context = context;
    }

    PBody normalizeBody(PBody body) throws QueryPlannerException {
        this.unifyVariablesAlongEqualities(body);
        this.eliminateWeakInequalities(body);
        this.eliminateInferrableUnaryTypes(body, this.context);
        this.removeMootEqualities(body);
        this.checkSanity(body);
        return body;
    }

    private void removeMootEqualities(PBody body) {
        Set<Equality> equals = body.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (!equality.isMoot()) continue;
            equality.delete();
        }
    }

    void unifyVariablesAlongEqualities(PBody body) {
        Set<Equality> equals = body.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (equality.isMoot()) continue;
            equality.getWho().unifyInto(equality.getWithWhom());
        }
    }

    void eliminateWeakInequalities(PBody body) {
        for (Inequality inequality : body.getConstraintsOfType(Inequality.class)) {
            inequality.eliminateWeak();
        }
    }

    void eliminateInferrableUnaryTypes(PBody body, IPatternMatcherContext context) {
        Set<TypeUnary> constraintsOfType = body.getConstraintsOfType(TypeUnary.class);
        block0: for (TypeUnary typeUnary : constraintsOfType) {
            PVariable var = (PVariable)typeUnary.getVariablesTuple().get(0);
            Object expressedType = typeUnary.getTypeInfo(var);
            Set<ITypeInfoProviderConstraint> typeRestrictors = var.getReferringConstraintsOfType(ITypeInfoProviderConstraint.class);
            typeRestrictors.remove(typeUnary);
            for (ITypeInfoProviderConstraint iTypeRestriction : typeRestrictors) {
                Set<Object> typeClosure;
                Object typeInfo = iTypeRestriction.getTypeInfo(var);
                if (typeInfo == ITypeInfoProviderConstraint.TypeInfoSpecials.NO_TYPE_INFO_PROVIDED || !(typeClosure = TypeHelper.typeClosure(Collections.singleton(typeInfo), context)).contains(expressedType)) continue;
                typeUnary.delete();
                continue block0;
            }
        }
    }

    void checkSanity(PBody body) throws QueryPlannerException {
        for (PConstraint pConstraint : body.getConstraints()) {
            pConstraint.checkSanity();
        }
    }
}

