/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.FlattenerCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.IConstraintFilter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.IFlattenCallPredicate;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.IVariableRenamer;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;

public class PQueryFlattener
extends PDisjunctionRewriter {
    private static final String FLATTENING_ERROR_MESSAGE = "Error occured while flattening";
    private IFlattenCallPredicate flattenCallPredicate;

    public PQueryFlattener(IFlattenCallPredicate flattenCallPredicate) {
        this.flattenCallPredicate = flattenCallPredicate;
    }

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        PQuery query = disjunction.getQuery();
        Set<PQuery> allReferredQueries = disjunction.getAllReferredQueries();
        for (PQuery referredQuery : allReferredQueries) {
            if (!referredQuery.getAllReferredQueries().contains(referredQuery)) continue;
            throw new RewriterException("Recursive queries are not supported, can't flatten query named \"{1}\"", new String[]{query.getFullyQualifiedName()}, "Unsupported recursive query", query);
        }
        try {
            return this.doFlatten(disjunction);
        }
        catch (Exception e) {
            throw new RewriterException(FLATTENING_ERROR_MESSAGE, new String[0], FLATTENING_ERROR_MESSAGE, query, e);
        }
    }

    public PDisjunction flatten(PQuery pQuery) {
        try {
            return this.rewrite(pQuery.getDisjunctBodies());
        }
        catch (RewriterException e) {
            throw new RuntimeException(e);
        }
    }

    private PDisjunction doFlatten(PDisjunction rootDisjunction) {
        Set containerSet;
        PBody pBody;
        Object item;
        HashMap flatBodyMapping = Maps.newHashMap();
        ArrayDeque preStack = Queues.newArrayDeque();
        ArrayDeque postStack = Queues.newArrayDeque();
        ArrayList callsToFlatten = Lists.newArrayList();
        preStack.push(rootDisjunction);
        while (!preStack.isEmpty()) {
            item = preStack.pop();
            postStack.push(item);
            if (item instanceof PDisjunction) {
                PDisjunction disjunction = (PDisjunction)item;
                HashSet flatBodies = Sets.newHashSet();
                if (this.isFlatteningNeeded(disjunction)) {
                    for (PBody pBody2 : disjunction.getBodies()) {
                        preStack.push(pBody2);
                    }
                } else {
                    for (PBody pBody2 : disjunction.getBodies()) {
                        flatBodies.add(this.prepareFlatPBody(pBody2));
                    }
                }
                flatBodyMapping.put(disjunction, flatBodies);
                continue;
            }
            if (!(item instanceof PBody)) continue;
            pBody = (PBody)item;
            containerSet = (Set)flatBodyMapping.get(pBody.getContainerDisjunction());
            if (this.isFlatteningNeeded(pBody)) {
                for (PConstraint pConstraint : pBody.getConstraints()) {
                    PositivePatternCall positivePatternCall;
                    if (!(pConstraint instanceof PositivePatternCall) || !this.flattenCallPredicate.shouldFlatten(positivePatternCall = (PositivePatternCall)pConstraint)) continue;
                    PDisjunction disjunction = positivePatternCall.getReferredQuery().getDisjunctBodies();
                    preStack.push(disjunction);
                    callsToFlatten.add(positivePatternCall);
                }
                continue;
            }
            containerSet.add(this.prepareFlatPBody(pBody));
        }
        while (!postStack.isEmpty()) {
            item = postStack.pop();
            if (!(item instanceof PBody)) continue;
            pBody = (PBody)item;
            containerSet = (Set)flatBodyMapping.get(pBody.getContainerDisjunction());
            if (!this.isFlatteningNeeded(pBody)) continue;
            ArrayList flattenedBodies = Lists.newArrayList();
            for (PConstraint pConstraint : pBody.getConstraints()) {
                PositivePatternCall positivePatternCall;
                if (!(pConstraint instanceof PositivePatternCall) || !this.flattenCallPredicate.shouldFlatten(positivePatternCall = (PositivePatternCall)pConstraint)) continue;
                PDisjunction disjunction = positivePatternCall.getReferredQuery().getDisjunctBodies();
                flattenedBodies.add((Set)flatBodyMapping.get(disjunction));
            }
            containerSet.addAll(this.createSetOfFlatPBodies(pBody, flattenedBodies, callsToFlatten));
        }
        return new PDisjunction(rootDisjunction.getQuery(), (Set)flatBodyMapping.get(rootDisjunction));
    }

    private Set<PBody> createSetOfFlatPBodies(PBody pBody, List<Set<PBody>> flattenedBodies, List<PositivePatternCall> flattenedCalls) {
        PQuery pQuery = pBody.getPattern();
        Set conjunctBodyLists = Sets.cartesianProduct(flattenedBodies);
        HashSet conjunctedBodies = Sets.newHashSet();
        for (List bodyList : conjunctBodyLists) {
            PBodyCopier copier = this.createBodyCopier(pQuery, flattenedCalls, bodyList);
            int i = 0;
            IVariableRenamer.HierarchicalName hierarchicalNamingTool = new IVariableRenamer.HierarchicalName();
            for (PBody calledBody : bodyList) {
                hierarchicalNamingTool.setCallCount(i++);
                copier.mergeBody(calledBody, hierarchicalNamingTool, new IConstraintFilter.ExportedParameterFilter());
            }
            copier.mergeBody(pBody);
            PBody copiedBody = copier.getCopiedBody();
            copiedBody.setStatus(PQuery.PQueryStatus.OK);
            conjunctedBodies.add(copiedBody);
        }
        return conjunctedBodies;
    }

    protected PBodyCopier createBodyCopier(PQuery query, List<PositivePatternCall> flattenedCalls, List<PBody> calledBodies) {
        return new FlattenerCopier(query, flattenedCalls, calledBodies);
    }

    private PBody prepareFlatPBody(PBody pBody) {
        PBodyCopier copier = this.createBodyCopier(pBody.getPattern(), Lists.newArrayList(), Lists.newArrayList());
        copier.mergeBody(pBody, new IVariableRenamer.SameName(), new IConstraintFilter.AllowAllFilter());
        return copier.getCopiedBody();
    }

    private boolean isFlatteningNeeded(PDisjunction pDisjunction) {
        boolean needsFlattening = false;
        for (PBody pBody : pDisjunction.getBodies()) {
            needsFlattening |= this.isFlatteningNeeded(pBody);
        }
        return needsFlattening;
    }

    private boolean isFlatteningNeeded(PBody pBody) {
        for (PConstraint pConstraint : pBody.getConstraints()) {
            if (!(pConstraint instanceof PositivePatternCall)) continue;
            return this.flattenCallPredicate.shouldFlatten((PositivePatternCall)pConstraint);
        }
        return false;
    }
}

