/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.basiclinear;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.SubPlanFactory;
import org.eclipse.incquery.runtime.matchers.planning.helpers.BuildHelper;
import org.eclipse.incquery.runtime.matchers.planning.operations.PApply;
import org.eclipse.incquery.runtime.matchers.planning.operations.POperation;
import org.eclipse.incquery.runtime.matchers.planning.operations.PProject;
import org.eclipse.incquery.runtime.matchers.planning.operations.PStart;
import org.eclipse.incquery.runtime.matchers.psystem.DeferredPConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.VariableDeferredPConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.basiclinear.OrderingHeuristics;

public class BasicLinearLayout
implements IQueryPlannerStrategy {
    public SubPlan plan(PBody pSystem, IPatternMatcherContext context) throws QueryPlannerException {
        SubPlanFactory planFactory = new SubPlanFactory(pSystem);
        PQuery query = pSystem.getPattern();
        try {
            context.logDebug(String.format("%s: patternbody build started for %s", this.getClass().getSimpleName(), query.getFullyQualifiedName()));
            SubPlan plan = planFactory.createSubPlan((POperation)new PStart(new PVariable[0]), new SubPlan[0]);
            Set pQueue = CollectionsFactory.getSet(pSystem.getConstraints());
            while (!pQueue.isEmpty()) {
                DeferredPConstraint deferred;
                PConstraint pConstraint = Collections.min(pQueue, new OrderingHeuristics(plan, context));
                pQueue.remove(pConstraint);
                if (pConstraint instanceof DeferredPConstraint && !(deferred = (DeferredPConstraint)pConstraint).isReadyAt(plan, context)) {
                    this.raiseForeverDeferredError(deferred, plan, context);
                }
                plan = planFactory.createSubPlan((POperation)new PApply(pConstraint), new SubPlan[]{plan});
            }
            SubPlan finalPlan = planFactory.createSubPlan((POperation)new PProject(pSystem.getSymbolicParameterVariables()), new SubPlan[]{plan});
            BuildHelper.finalCheck((PBody)pSystem, (SubPlan)finalPlan, (IPatternMatcherContext)context);
            context.logDebug(String.format("%s: patternbody query plan concluded for %s as: %s", this.getClass().getSimpleName(), query.getFullyQualifiedName(), finalPlan.toLongString()));
            return finalPlan;
        }
        catch (RetePatternBuildException ex) {
            ex.setPatternDescription(query);
            throw ex;
        }
    }

    private void raiseForeverDeferredError(DeferredPConstraint constraint, SubPlan plan, IPatternMatcherContext context) throws RetePatternBuildException {
        if (constraint instanceof Equality) {
            this.raiseForeverDeferredError((Equality)constraint, plan, context);
        } else if (constraint instanceof ExportedParameter) {
            this.raiseForeverDeferredError((ExportedParameter)constraint, plan, context);
        } else if (constraint instanceof ExpressionEvaluation) {
            this.raiseForeverDeferredError((ExpressionEvaluation)constraint, plan, context);
        } else if (constraint instanceof VariableDeferredPConstraint) {
            this.raiseForeverDeferredError(constraint, plan, context);
        }
    }

    private void raiseForeverDeferredError(Equality constraint, SubPlan plan, IPatternMatcherContext context) throws RetePatternBuildException {
        String[] args = new String[]{constraint.getWho().toString(), constraint.getWithWhom().toString()};
        String msg = "Cannot express equality of variables {1} and {2} if neither of them is deducable.";
        String shortMsg = "Equality between undeducible variables.";
        throw new RetePatternBuildException(msg, args, shortMsg, null);
    }

    private void raiseForeverDeferredError(ExportedParameter constraint, SubPlan plan, IPatternMatcherContext context) throws RetePatternBuildException {
        String[] args = new String[]{constraint.getParameterName().toString()};
        String msg = "Pattern Graph Search terminated incompletely: exported pattern variable {1} could not be determined based on the pattern constraints. HINT: certain constructs (e.g. negative patterns or check expressions) cannot output symbolic parameters.";
        String shortMsg = "Could not deduce value of parameter";
        throw new RetePatternBuildException(msg, args, shortMsg, null);
    }

    private void raiseForeverDeferredError(ExpressionEvaluation constraint, SubPlan plan, IPatternMatcherContext context) throws RetePatternBuildException {
        if (constraint.checkTypeSafety(plan, context) != null) {
            String[] args = new String[]{this.toString(), constraint.checkTypeSafety(plan, context).toString()};
            String msg = "The checking of pattern constraint {1} cannot be deferred further, but variable {2} is still not type safe. HINT: the incremental matcher is not an equation solver, please make sure that all variable values are deducible.";
            String shortMsg = "Could not check all constraints due to undeducible type restrictions";
            throw new RetePatternBuildException(msg, args, shortMsg, null);
        }
        this.raiseForeverDeferredError((VariableDeferredPConstraint)constraint, plan);
    }

    private void raiseForeverDeferredError(VariableDeferredPConstraint constraint, SubPlan plan) throws RetePatternBuildException {
        Set missing = CollectionsFactory.getSet(constraint.getDeferringVariables());
        missing.removeAll(plan.getVisibleVariables());
        String[] args = new String[]{this.toString(), Arrays.toString(missing.toArray())};
        String msg = "The checking of pattern constraint {1} requires the values of variables {2}, but it cannot be deferred further. HINT: the incremental matcher is not an equation solver, please make sure that all variable values are deducible.";
        String shortMsg = "Could not check all constraints due to undeducible variables";
        throw new RetePatternBuildException(msg, args, shortMsg, null);
    }
}

