/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.eval;

import java.util.Collection;
import java.util.Map;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.util.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.eval.AbstractEvaluatorNode;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.tuple.Clearable;

public abstract class OutputCachingEvaluatorNode
extends AbstractEvaluatorNode
implements Clearable {
    Map<Tuple, Tuple> outputCache = CollectionsFactory.getMap();

    public OutputCachingEvaluatorNode(ReteContainer reteContainer, IPatternMatcherRuntimeContext context, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth) {
        super(reteContainer, context, evaluator, parameterPositions, sourceTupleWidth);
        reteContainer.registerClearable(this);
    }

    @Override
    public void clear() {
        this.outputCache.clear();
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (Tuple output : this.outputCache.values()) {
            collector.add(output);
        }
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        switch (direction) {
            case INSERT: {
                Tuple insertedOutput = this.tupleFromResult(updateElement, this.evaluateTerm(updateElement));
                if (insertedOutput == null) break;
                this.outputCache.put(updateElement, insertedOutput);
                this.propagateUpdate(direction, insertedOutput);
                break;
            }
            case REVOKE: {
                Tuple revokedOutput = this.outputCache.remove(updateElement);
                if (revokedOutput == null) break;
                this.propagateUpdate(direction, revokedOutput);
            }
        }
    }
}

