/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.plancompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.psystem.EnumerablePConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.construction.plancompiler.ReteRecipeCompiler;
import org.eclipse.incquery.runtime.rete.recipes.AggregatorRecipe;
import org.eclipse.incquery.runtime.rete.recipes.EqualityFilterRecipe;
import org.eclipse.incquery.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.JoinRecipe;
import org.eclipse.incquery.runtime.rete.recipes.Mask;
import org.eclipse.incquery.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.RecipesFactory;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TrimmerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.helper.RecipesHelper;
import org.eclipse.incquery.runtime.rete.traceability.CompiledQuery;
import org.eclipse.incquery.runtime.rete.traceability.PlanningTrace;
import org.eclipse.incquery.runtime.rete.traceability.RecipeTraceInfo;

public class CompilerHelper {
    static final RecipesFactory FACTORY = RecipesFactory.eINSTANCE;

    public static PlanningTrace checkAndTrimEqualVariables(SubPlan plan, PlanningTrace coreTrace) {
        int distinctVariables;
        List<PVariable> coreVariablesTuple = coreTrace.getVariablesTuple();
        int constraintArity = coreVariablesTuple.size();
        if (constraintArity == (distinctVariables = coreTrace.getPosMapping().size())) {
            return coreTrace;
        }
        HashMap<PVariable, TreeSet<Integer>> posMultimap = new HashMap<PVariable, TreeSet<Integer>>();
        ArrayList<PVariable> trimmedVariablesTuple = new ArrayList<PVariable>(distinctVariables);
        int[] trimIndices = new int[distinctVariables];
        int i = 0;
        while (i < constraintArity) {
            PVariable variable = coreVariablesTuple.get(i);
            TreeSet<Integer> indexSet = (TreeSet<Integer>)posMultimap.get(variable);
            if (indexSet == null) {
                indexSet = new TreeSet<Integer>();
                posMultimap.put(variable, indexSet);
                trimIndices[trimmedVariablesTuple.size()] = i;
                trimmedVariablesTuple.add(variable);
            }
            indexSet.add(i);
            ++i;
        }
        PlanningTrace lastTrace = coreTrace;
        for (Map.Entry entry : posMultimap.entrySet()) {
            if (((SortedSet)entry.getValue()).size() <= 1) continue;
            EqualityFilterRecipe equalityFilterRecipe = FACTORY.createEqualityFilterRecipe();
            equalityFilterRecipe.setParent(lastTrace.getRecipe());
            equalityFilterRecipe.getIndices().addAll((Collection)entry.getValue());
            lastTrace = new PlanningTrace(plan, coreVariablesTuple, (ReteNodeRecipe)equalityFilterRecipe, lastTrace);
        }
        TrimmerRecipe trimmerRecipe = FACTORY.createTrimmerRecipe();
        trimmerRecipe.setParent(lastTrace.getRecipe());
        trimmerRecipe.setMask(RecipesHelper.mask((int)constraintArity, (int[])trimIndices));
        return new PlanningTrace(plan, trimmedVariablesTuple, (ReteNodeRecipe)trimmerRecipe, lastTrace);
    }

    public static List<PVariable> convertVariablesTuple(EnumerablePConstraint constraint) {
        return CompilerHelper.convertVariablesTuple(constraint.getVariablesTuple());
    }

    public static List<PVariable> convertVariablesTuple(Tuple variablesTuple) {
        ArrayList<PVariable> result = new ArrayList<PVariable>();
        Object[] objectArray = variablesTuple.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            result.add((PVariable)o);
            ++n2;
        }
        return result;
    }

    public static RecipeTraceInfo makeIndexerTrace(SubPlan planToCompile, PlanningTrace parentTrace, TupleMask mask) {
        ReteNodeRecipe parentRecipe = parentTrace.getRecipe();
        if (parentRecipe instanceof AggregatorRecipe) {
            throw new IllegalArgumentException("Cannot take projection indexer of aggregator node at plan " + planToCompile);
        }
        ProjectionIndexerRecipe recipe = RecipesHelper.projectionIndexerRecipe((ReteNodeRecipe)parentRecipe, (Mask)RecipesHelper.mask((int)mask.sourceWidth, (int[])mask.indices));
        return new PlanningTrace(planToCompile, parentTrace.getVariablesTuple(), (ReteNodeRecipe)recipe, parentTrace);
    }

    protected static TrimmerRecipe makeTrimmerRecipe(PlanningTrace compiledParent, List<PVariable> projectedVariables) {
        Mask projectionMask = CompilerHelper.makeProjectionMask(compiledParent, projectedVariables);
        TrimmerRecipe trimmerRecipe = ReteRecipeCompiler.FACTORY.createTrimmerRecipe();
        trimmerRecipe.setParent(compiledParent.getRecipe());
        trimmerRecipe.setMask(projectionMask);
        return trimmerRecipe;
    }

    public static Mask makeProjectionMask(PlanningTrace compiledParent, Iterable<PVariable> projectedVariables) {
        ArrayList<Integer> projectionSourceIndices = new ArrayList<Integer>();
        for (PVariable pVariable : projectedVariables) {
            projectionSourceIndices.add(compiledParent.getPosMapping().get(pVariable));
        }
        Mask projectionMask = RecipesHelper.mask((int)compiledParent.getRecipe().getArity(), projectionSourceIndices);
        return projectionMask;
    }

    public static CompiledQuery makeQueryTrace(PQuery query, Collection<RecipeTraceInfo> bodyFinalTraces, Collection<ReteNodeRecipe> bodyFinalRecipes) {
        ProductionRecipe recipe = ReteRecipeCompiler.FACTORY.createProductionRecipe();
        recipe.setPattern((Object)query);
        recipe.setPatternFQN(query.getFullyQualifiedName());
        recipe.setTraceInfo(recipe.getPatternFQN());
        recipe.getParents().addAll(bodyFinalRecipes);
        int i = 0;
        while (i < query.getParameterNames().size()) {
            recipe.getMappedIndices().put((Object)((String)query.getParameterNames().get(i)), (Object)i);
            ++i;
        }
        return new CompiledQuery((ReteNodeRecipe)recipe, bodyFinalTraces, query);
    }

    public static class JoinHelper {
        private TupleMask primaryMask;
        private TupleMask secondaryMask;
        private TupleMask complementerMask;
        private RecipeTraceInfo primaryIndexer;
        private RecipeTraceInfo secondaryIndexer;
        private JoinRecipe naturalJoinRecipe;
        private List<PVariable> naturalJoinVariablesTuple;

        public JoinHelper(SubPlan planToCompile, PlanningTrace primaryCompiled, PlanningTrace callTrace) {
            HashSet<PVariable> primaryVariables = new HashSet<PVariable>(primaryCompiled.getVariablesTuple());
            HashSet<PVariable> secondaryVariables = new HashSet<PVariable>(callTrace.getVariablesTuple());
            int oldNodes = 0;
            TreeSet<Integer> introducingSecondaryIndices = new TreeSet<Integer>();
            for (PVariable var : secondaryVariables) {
                if (primaryVariables.contains(var)) {
                    ++oldNodes;
                    continue;
                }
                introducingSecondaryIndices.add(callTrace.getPosMapping().get(var));
            }
            int[] primaryIndices = new int[oldNodes];
            int[] secondaryIndices = new int[oldNodes];
            int k = 0;
            for (PVariable var : secondaryVariables) {
                if (!primaryVariables.contains(var)) continue;
                primaryIndices[k] = primaryCompiled.getPosMapping().get(var);
                secondaryIndices[k] = callTrace.getPosMapping().get(var);
                ++k;
            }
            int[] complementerIndices = new int[introducingSecondaryIndices.size()];
            int l = 0;
            for (Integer integer : introducingSecondaryIndices) {
                complementerIndices[l++] = integer;
            }
            this.primaryMask = new TupleMask(primaryIndices, primaryCompiled.getVariablesTuple().size());
            this.secondaryMask = new TupleMask(secondaryIndices, callTrace.getVariablesTuple().size());
            this.complementerMask = new TupleMask(complementerIndices, callTrace.getVariablesTuple().size());
            this.primaryIndexer = CompilerHelper.makeIndexerTrace(planToCompile, primaryCompiled, this.primaryMask);
            this.secondaryIndexer = CompilerHelper.makeIndexerTrace(planToCompile, callTrace, this.secondaryMask);
            this.naturalJoinRecipe = FACTORY.createJoinRecipe();
            this.naturalJoinRecipe.setLeftParent((ProjectionIndexerRecipe)this.primaryIndexer.getRecipe());
            this.naturalJoinRecipe.setRightParent((IndexerRecipe)this.secondaryIndexer.getRecipe());
            this.naturalJoinRecipe.setRightParentComplementaryMask(RecipesHelper.mask((int)this.complementerMask.sourceWidth, (int[])this.complementerMask.indices));
            this.naturalJoinVariablesTuple = new ArrayList<PVariable>(primaryCompiled.getVariablesTuple());
            int[] nArray = this.complementerMask.indices;
            int n = this.complementerMask.indices.length;
            int n2 = 0;
            while (n2 < n) {
                int complementerIndex = nArray[n2];
                this.naturalJoinVariablesTuple.add(callTrace.getVariablesTuple().get(complementerIndex));
                ++n2;
            }
        }

        public TupleMask getPrimaryMask() {
            return this.primaryMask;
        }

        public TupleMask getSecondaryMask() {
            return this.secondaryMask;
        }

        public TupleMask getComplementerMask() {
            return this.complementerMask;
        }

        public RecipeTraceInfo getPrimaryIndexer() {
            return this.primaryIndexer;
        }

        public RecipeTraceInfo getSecondaryIndexer() {
            return this.secondaryIndexer;
        }

        public JoinRecipe getNaturalJoinRecipe() {
            return this.naturalJoinRecipe;
        }

        public List<PVariable> getNaturalJoinVariablesTuple() {
            return this.naturalJoinVariablesTuple;
        }
    }
}

