/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.network;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.matchers.util.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.boundary.InputConnector;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.OnetimeIndexer;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.network.ConnectionFactory;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.NodeFactory;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.InputFilterRecipe;
import org.eclipse.incquery.runtime.rete.recipes.InputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.Mask;
import org.eclipse.incquery.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.RecipesFactory;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TransparentRecipe;
import org.eclipse.incquery.runtime.rete.recipes.helper.RecipesHelper;
import org.eclipse.incquery.runtime.rete.remote.Address;
import org.eclipse.incquery.runtime.rete.remote.RemoteReceiver;
import org.eclipse.incquery.runtime.rete.remote.RemoteSupplier;
import org.eclipse.incquery.runtime.rete.traceability.ActiveNodeConflictTrace;
import org.eclipse.incquery.runtime.rete.traceability.RecipeTraceInfo;
import org.eclipse.incquery.runtime.rete.traceability.UserRequestTrace;
import org.eclipse.incquery.runtime.rete.util.Options;

public class NodeProvisioner {
    ReteContainer reteContainer;
    NodeFactory nodeFactory;
    ConnectionFactory connectionFactory;
    InputConnector inputConnector;
    IQueryRuntimeContext runtimeContext;
    Map<Supplier, RemoteReceiver> remoteReceivers = CollectionsFactory.getMap();
    Map<Address<? extends Supplier>, RemoteSupplier> remoteSuppliers = CollectionsFactory.getMap();
    private Table<RecipeTraceInfo, TupleMask, UserRequestTrace> projectionIndexerUserRequests = HashBasedTable.create();
    private Table<ReteNodeRecipe, TupleMask, ProjectionIndexerRecipe> resultSeedRecipes = HashBasedTable.create();

    public NodeProvisioner(ReteContainer reteContainer) {
        this.reteContainer = reteContainer;
        this.nodeFactory = reteContainer.getNodeFactory();
        this.connectionFactory = reteContainer.getConnectionFactory();
        this.inputConnector = reteContainer.getInputConnectionFactory();
        this.runtimeContext = reteContainer.getNetwork().getEngine().getRuntimeContext();
    }

    public synchronized Address<? extends Node> getOrCreateNodeByRecipe(RecipeTraceInfo recipeTrace) {
        ReteNodeRecipe recipe = recipeTrace.getRecipe();
        Address<? extends Node> result = this.getNodesByRecipe().get(recipe);
        if (result != null) {
            if (this.getRecipeTraces().add(recipeTrace)) {
                result.getNodeCache().assignTraceInfo(recipeTrace);
            }
        } else {
            Collection<ReteNodeRecipe> sameClassRecipes = this.getSameClassRecipes(recipe);
            for (ReteNodeRecipe knownRecipe : sameClassRecipes) {
                if (!this.equivalentRecipes(recipe, knownRecipe) || (result = this.getNodesByRecipe().get(knownRecipe)) == null) continue;
                recipeTrace.shadowWithEquivalentRecipe(knownRecipe);
                this.getNodesByRecipe().put(recipe, result);
                if (!this.getRecipeTraces().add(recipeTrace)) break;
                result.getNodeCache().assignTraceInfo(recipeTrace);
                break;
            }
            if (result == null) {
                Node freshNode = this.instantiateNodeForRecipe(recipeTrace, recipe, sameClassRecipes);
                result = this.reteContainer.makeAddress(freshNode);
            }
        }
        return result;
    }

    private Set<RecipeTraceInfo> getRecipeTraces() {
        return this.reteContainer.network.recipeTraces;
    }

    private Node instantiateNodeForRecipe(RecipeTraceInfo recipeTrace, ReteNodeRecipe recipe, Collection<ReteNodeRecipe> sameClassRecipes) {
        this.getRecipeTraces().add(recipeTrace);
        if (recipe instanceof IndexerRecipe) {
            this.ensureParents(recipeTrace);
            ReteNodeRecipe parentRecipe = recipeTrace.getParentRecipeTraces().iterator().next().getRecipe();
            Indexer result = this.nodeFactory.createIndexer(this.reteContainer, (IndexerRecipe)recipe, this.asSupplier(this.reteContainer.network.getExistingNodeByRecipe(parentRecipe)), recipeTrace);
            if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
                this.getNodesByRecipe().put(recipe, this.reteContainer.makeAddress(result));
                sameClassRecipes.add(recipe);
            }
            return result;
        }
        Supplier result = this.nodeFactory.createNode(this.reteContainer, recipe, recipeTrace);
        if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
            this.getNodesByRecipe().put(recipe, this.reteContainer.makeAddress(result));
            sameClassRecipes.add(recipe);
        }
        if (recipe instanceof InputRecipe) {
            this.inputConnector.connectInput((InputRecipe)recipe, result);
        } else {
            if (recipe instanceof InputFilterRecipe) {
                this.inputConnector.connectInputFilter((InputFilterRecipe)recipe, result);
            }
            this.ensureParents(recipeTrace);
            this.connectionFactory.connectToParents(recipeTrace, result);
        }
        return result;
    }

    private Map<ReteNodeRecipe, Address<? extends Node>> getNodesByRecipe() {
        return this.reteContainer.network.nodesByRecipe;
    }

    private void ensureParents(RecipeTraceInfo recipeTrace) {
        for (RecipeTraceInfo parentTrace : recipeTrace.getParentRecipeTraces()) {
            this.getOrCreateNodeByRecipe(parentTrace);
        }
    }

    private boolean equivalentRecipes(ReteNodeRecipe recipe, ReteNodeRecipe knownRecipe) {
        return EcoreUtil.equals((EObject)recipe, (EObject)knownRecipe);
    }

    private Collection<ReteNodeRecipe> getSameClassRecipes(ReteNodeRecipe recipe) {
        Set sameClassRecipes = this.reteContainer.network.primaryRecipesByClass.get(recipe.eClass());
        if (sameClassRecipes == null) {
            sameClassRecipes = CollectionsFactory.getSet();
            this.reteContainer.network.primaryRecipesByClass.put(recipe.eClass(), sameClassRecipes);
        }
        return sameClassRecipes;
    }

    synchronized RemoteReceiver accessRemoteReceiver(Address<? extends Supplier> address) {
        throw new UnsupportedOperationException("Multi-container Rete not supported yet");
    }

    synchronized RemoteSupplier accessRemoteSupplier(Address<? extends Supplier> address) {
        throw new UnsupportedOperationException("Multi-container Rete not supported yet");
    }

    public Supplier asSupplier(Address<? extends Supplier> address) {
        if (!this.reteContainer.isLocal(address)) {
            return this.accessRemoteSupplier(address);
        }
        return this.reteContainer.resolveLocal(address);
    }

    public synchronized ProjectionIndexer accessProjectionIndexer(RecipeTraceInfo productionTrace, TupleMask mask) {
        UserRequestTrace indexerTrace = (UserRequestTrace)this.projectionIndexerUserRequests.get((Object)productionTrace, (Object)mask);
        if (indexerTrace == null) {
            ProjectionIndexerRecipe projectionIndexerRecipe = this.projectionIndexerRecipe(productionTrace, mask);
            indexerTrace = new UserRequestTrace((ReteNodeRecipe)projectionIndexerRecipe, productionTrace);
            this.projectionIndexerUserRequests.put((Object)productionTrace, (Object)mask, (Object)indexerTrace);
        }
        Address<? extends Node> address = this.getOrCreateNodeByRecipe(indexerTrace);
        return (ProjectionIndexer)this.reteContainer.resolveLocal(address);
    }

    public synchronized ProjectionIndexer accessProjectionIndexerOnetime(RecipeTraceInfo supplierTrace, TupleMask mask) {
        if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
            return this.accessProjectionIndexer(supplierTrace, mask);
        }
        Address<? extends Node> supplierAddress = this.getOrCreateNodeByRecipe(supplierTrace);
        Supplier supplier = (Supplier)this.reteContainer.resolveLocal(supplierAddress);
        this.reteContainer.flushUpdates();
        OnetimeIndexer result = new OnetimeIndexer(this.reteContainer, mask);
        this.reteContainer.sendConstructionUpdates(result, Direction.INSERT, this.reteContainer.pullContents(supplier));
        this.reteContainer.flushUpdates();
        return result;
    }

    public synchronized ProjectionIndexer peekProjectionIndexer(RecipeTraceInfo supplierTrace, TupleMask mask) {
        Address<? extends Node> address = this.getNodesByRecipe().get(this.projectionIndexerRecipe(supplierTrace, mask));
        return address == null ? null : (ProjectionIndexer)this.reteContainer.resolveLocal(address);
    }

    private ProjectionIndexerRecipe projectionIndexerRecipe(RecipeTraceInfo parentTrace, TupleMask mask) {
        ReteNodeRecipe parentRecipe = parentTrace.getRecipe();
        ProjectionIndexerRecipe projectionIndexerRecipe = (ProjectionIndexerRecipe)this.resultSeedRecipes.get((Object)parentRecipe, (Object)mask);
        if (projectionIndexerRecipe == null) {
            projectionIndexerRecipe = RecipesHelper.projectionIndexerRecipe((ReteNodeRecipe)parentRecipe, (Mask)RecipesHelper.mask((int)mask.sourceWidth, (int[])mask.indices));
            this.resultSeedRecipes.put((Object)parentRecipe, (Object)mask, (Object)projectionIndexerRecipe);
        }
        return projectionIndexerRecipe;
    }

    RecipeTraceInfo accessActiveIndexer(RecipeTraceInfo inactiveIndexerRecipeTrace) {
        RecipeTraceInfo parentRecipeTrace = inactiveIndexerRecipeTrace.getParentRecipeTraces().iterator().next();
        ProjectionIndexerRecipe inactiveIndexerRecipe = (ProjectionIndexerRecipe)inactiveIndexerRecipeTrace.getRecipe();
        TransparentRecipe transparentRecipe = RecipesFactory.eINSTANCE.createTransparentRecipe();
        transparentRecipe.setParent(parentRecipeTrace.getRecipe());
        ActiveNodeConflictTrace transparentRecipeTrace = new ActiveNodeConflictTrace((ReteNodeRecipe)transparentRecipe, parentRecipeTrace, inactiveIndexerRecipeTrace);
        ProjectionIndexerRecipe activeIndexerRecipe = RecipesFactory.eINSTANCE.createProjectionIndexerRecipe();
        activeIndexerRecipe.setParent((ReteNodeRecipe)transparentRecipe);
        activeIndexerRecipe.setMask(inactiveIndexerRecipe.getMask());
        ActiveNodeConflictTrace activeIndexerRecipeTrace = new ActiveNodeConflictTrace((ReteNodeRecipe)activeIndexerRecipe, (RecipeTraceInfo)transparentRecipeTrace, inactiveIndexerRecipeTrace);
        return activeIndexerRecipeTrace;
    }
}

