/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.context.EMFPatternMatcherContext;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyNormalizer;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public abstract class BaseQuerySpecification<Matcher extends IncQueryMatcher<? extends IPatternMatch>>
implements IQuerySpecification<Matcher> {
    private static final Logger LOGGER = IncQueryLoggingUtil.getLogger(BaseQuerySpecification.class);
    protected static final IPatternMatcherContext CONTEXT = new EMFPatternMatcherContext(LOGGER);
    protected static final PBodyNormalizer NORMALIZER = new PBodyNormalizer(CONTEXT);
    protected PQuery.PQueryStatus status = PQuery.PQueryStatus.UNINITIALIZED;
    protected List<PProblem> pProblems = new ArrayList<PProblem>();
    private List<PAnnotation> annotations = new ArrayList<PAnnotation>();
    PDisjunction canonicalDisjunction;

    protected abstract Matcher instantiate(IncQueryEngine var1) throws IncQueryException;

    @Override
    public Matcher getMatcher(Notifier emfRoot) throws IncQueryException {
        IncQueryEngine engine = IncQueryEngine.on(emfRoot);
        return this.instantiate(engine);
    }

    @Override
    public Matcher getMatcher(IncQueryEngine engine) throws IncQueryException {
        return this.instantiate(engine);
    }

    public Integer getPositionOfParameter(String parameterName) {
        int index = this.getParameterNames().indexOf(parameterName);
        return index != -1 ? Integer.valueOf(index) : null;
    }

    protected void setStatus(PQuery.PQueryStatus newStatus) {
        this.status = newStatus;
    }

    protected void addError(PProblem problem) {
        this.status = PQuery.PQueryStatus.ERROR;
        this.pProblems.add(problem);
    }

    public PQuery.PQueryStatus getStatus() {
        return this.status;
    }

    public List<PProblem> getPProblems() {
        return Collections.unmodifiableList(this.pProblems);
    }

    public boolean isMutable() {
        return this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED);
    }

    public void checkMutability() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isMutable(), (Object)("Cannot edit query definition " + this.getFullyQualifiedName()));
    }

    protected void addAnnotation(PAnnotation annotation) {
        this.checkMutability();
        this.annotations.add(annotation);
    }

    public List<PAnnotation> getAllAnnotations() {
        return Lists.newArrayList(this.annotations);
    }

    public List<PAnnotation> getAnnotationsByName(String annotationName) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.annotations, (Predicate)new AnnotationNameTester(annotationName)));
    }

    public PAnnotation getFirstAnnotationByName(String annotationName) {
        return (PAnnotation)Iterables.find(this.annotations, (Predicate)new AnnotationNameTester(annotationName), null);
    }

    public List<String> getParameterNames() {
        return Lists.transform((List)this.getParameters(), (Function)PQueries.parameterNameFunction());
    }

    public Set<PQuery> getDirectReferredQueries() {
        Iterable queries = Iterables.concat((Iterable)Iterables.transform((Iterable)this.canonicalDisjunction.getBodies(), (Function)PQueries.directlyReferencedQueriesFunction()));
        return Sets.newHashSet((Iterable)queries);
    }

    public Set<PQuery> getAllReferredQueries() {
        HashSet processedQueries = Sets.newHashSet((Object[])new PQuery[]{this});
        Set<PQuery> foundQueries = this.getDirectReferredQueries();
        HashSet newQueries = Sets.newHashSet(foundQueries);
        while (!processedQueries.containsAll(newQueries)) {
            PQuery query = (PQuery)newQueries.iterator().next();
            processedQueries.add(query);
            newQueries.remove(query);
            Set referred = query.getDirectReferredQueries();
            referred.removeAll(processedQueries);
            foundQueries.addAll(referred);
            newQueries.addAll(referred);
        }
        return foundQueries;
    }

    public PDisjunction getDisjunctBodies() {
        this.ensureInitialized();
        Preconditions.checkState((!this.status.equals((Object)PQuery.PQueryStatus.ERROR) ? 1 : 0) != 0, (Object)("Query " + this.getFullyQualifiedName() + " contains errors."));
        return this.canonicalDisjunction;
    }

    protected final void ensureInitialized() {
        try {
            if (this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED)) {
                this.setBodies(this.doGetContainedBodies());
                this.setStatus(PQuery.PQueryStatus.OK);
            }
        }
        catch (IncQueryException e) {
            this.addError(new PProblem((Exception)e, e.getShortMessage()));
            throw new RuntimeException(e);
        }
        catch (RewriterException e) {
            this.addError(new PProblem((QueryPlannerException)((Object)e)));
            throw new RuntimeException(e);
        }
    }

    protected final void setBodies(Set<PBody> bodies) throws RewriterException {
        this.canonicalDisjunction = new PDisjunction((PQuery)this, bodies);
        for (PBody body : this.canonicalDisjunction.getBodies()) {
            body.setStatus(null);
        }
        NORMALIZER.rewrite(this.canonicalDisjunction);
        this.setStatus(PQuery.PQueryStatus.OK);
    }

    protected abstract Set<PBody> doGetContainedBodies() throws IncQueryException;

    private final class AnnotationNameTester
    implements Predicate<PAnnotation> {
        private final String annotationName;

        private AnnotationNameTester(String annotationName) {
            this.annotationName = annotationName;
        }

        public boolean apply(PAnnotation annotation) {
            return annotation == null ? false : this.annotationName.equals(annotation.getName());
        }
    }
}

