/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.context;

import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;

public class EMFPatternMatcherContext
implements IPatternMatcherContext {
    private static final String INVALID_TYPE_ERROR = "typeObject has invalid type ";
    private Logger logger = Logger.getLogger(EMFPatternMatcherContext.class);

    public EMFPatternMatcherContext() {
    }

    public EMFPatternMatcherContext(Logger logger) {
        this.logger = logger;
    }

    public IPatternMatcherContext.EdgeInterpretation edgeInterpretation() {
        return IPatternMatcherContext.EdgeInterpretation.BINARY;
    }

    public IPatternMatcherContext.GeneralizationQueryDirection allowedGeneralizationQueryDirection() {
        return IPatternMatcherContext.GeneralizationQueryDirection.SUPERTYPE_ONLY_SMART_NOTIFICATIONS;
    }

    public Collection<? extends Object> enumerateDirectSupertypes(Object typeObject) {
        if (typeObject == null) {
            return null;
        }
        if (typeObject instanceof EClass || typeObject instanceof EDataType) {
            return this.enumerateDirectUnarySupertypes(typeObject);
        }
        if (typeObject instanceof EStructuralFeature) {
            return this.enumerateDirectBinaryEdgeSupertypes(typeObject);
        }
        throw new IllegalArgumentException(INVALID_TYPE_ERROR + typeObject.getClass().getName());
    }

    public Collection<? extends Object> enumerateDirectSubtypes(Object typeObject) {
        if (typeObject == null) {
            return null;
        }
        if (typeObject instanceof EClass || typeObject instanceof EDataType) {
            return this.enumerateDirectUnarySubtypes(typeObject);
        }
        if (typeObject instanceof EStructuralFeature) {
            return this.enumerateDirectBinaryEdgeSubtypes(typeObject);
        }
        throw new IllegalArgumentException(INVALID_TYPE_ERROR + typeObject.getClass().getName());
    }

    public boolean isUnaryType(Object typeObject) {
        return typeObject instanceof EClassifier;
    }

    public Collection<? extends Object> enumerateDirectUnarySubtypes(Object typeObject) {
        if (typeObject instanceof EClass) {
            throw new UnsupportedOperationException("EMF patternmatcher context only supports querying of supertypes, not subtypes.");
        }
        if (typeObject instanceof EDataType) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException(INVALID_TYPE_ERROR + typeObject.getClass().getName());
    }

    public Collection<? extends Object> enumerateDirectUnarySupertypes(Object typeObject) {
        if (typeObject instanceof EClass) {
            return ((EClass)typeObject).getESuperTypes();
        }
        if (typeObject instanceof EDataType) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException(INVALID_TYPE_ERROR + typeObject.getClass().getName());
    }

    public boolean isBinaryEdgeType(Object typeObject) {
        return typeObject instanceof EStructuralFeature;
    }

    public boolean isBinaryEdgeMultiplicityToOne(Object typeObject) {
        if (typeObject instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)typeObject;
            return !feature.isMany();
        }
        return false;
    }

    public boolean isBinaryEdgeMultiplicityOneTo(Object typeObject) {
        if (typeObject instanceof EReference) {
            EReference feature = (EReference)typeObject;
            EReference eOpposite = feature.getEOpposite();
            return feature.isContainment() || eOpposite != null && !eOpposite.isMany();
        }
        return false;
    }

    public Collection<? extends Object> enumerateDirectBinaryEdgeSubtypes(Object typeObject) {
        return Collections.emptyList();
    }

    public Collection<? extends Object> enumerateDirectBinaryEdgeSupertypes(Object typeObject) {
        return Collections.emptyList();
    }

    public Collection<? extends Object> enumerateDirectTernaryEdgeSubtypes(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public boolean isTernaryEdgeType(Object typeObject) {
        return false;
    }

    public boolean isTernaryEdgeMultiplicityOneTo(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public boolean isTernaryEdgeMultiplicityToOne(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Object> enumerateDirectTernaryEdgeSupertypes(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Object binaryEdgeSourceType(Object typeObject) {
        EStructuralFeature feature = (EStructuralFeature)typeObject;
        return feature.getEContainingClass();
    }

    public Object binaryEdgeTargetType(Object typeObject) {
        if (typeObject instanceof EAttribute) {
            EAttribute attribute = (EAttribute)typeObject;
            return attribute.getEAttributeType();
        }
        if (typeObject instanceof EReference) {
            EReference reference = (EReference)typeObject;
            return reference.getEReferenceType();
        }
        throw new IllegalArgumentException(INVALID_TYPE_ERROR + typeObject.getClass().getName());
    }

    public Object ternaryEdgeSourceType(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Object ternaryEdgeTargetType(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public void reportPatternDependency(Object pattern) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void logDebug(String message) {
        if (this.getLogger() != null) {
            this.getLogger().trace((Object)message);
        }
    }

    public void logError(String message) {
        if (this.getLogger() != null) {
            this.getLogger().error((Object)message);
        }
    }

    public void logError(String message, Throwable cause) {
        if (this.getLogger() != null) {
            this.getLogger().error((Object)message, cause);
        }
    }

    public void logFatal(String message) {
        if (this.getLogger() != null) {
            this.getLogger().fatal((Object)message);
        }
    }

    public void logFatal(String message, Throwable cause) {
        if (this.getLogger() != null) {
            this.getLogger().fatal((Object)message, cause);
        }
    }

    public void logWarning(String message) {
        if (this.getLogger() != null) {
            this.getLogger().warn((Object)message);
        }
    }

    public void logWarning(String message, Throwable cause) {
        if (this.getLogger() != null) {
            this.getLogger().warn((Object)message, cause);
        }
    }

    public String printType(Object typeObject) {
        if (typeObject == null) {
            return "(null)";
        }
        if (typeObject instanceof EClassifier) {
            EClassifier eClassifier = (EClassifier)typeObject;
            EPackage ePackage = eClassifier.getEPackage();
            String nsURI = ePackage == null ? null : ePackage.getNsURI();
            String typeName = eClassifier.getName();
            return nsURI + "/" + typeName;
        }
        if (typeObject instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)typeObject;
            return String.valueOf(this.printType(feature.getEContainingClass())) + "." + feature.getName();
        }
        return typeObject.toString();
    }
}

