/**
 * Copyright (c) 2010-2012, Andras Okros, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Andras Okros - initial API and implementation
 */
package org.eclipse.incquery.tooling.core.generator.jvmmodel;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.patternLanguage.CheckConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Constraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.extensibility.IMatchChecker;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.tooling.core.generator.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/**
 * {@link IMatchChecker} implementation inferer.
 */
@SuppressWarnings("all")
public class PatternMatchEvaluatorClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  @Extension
  private ITypeProvider _iTypeProvider;
  
  @Inject
  @Extension
  private Primitives _primitives;
  
  /**
   * Infers the {@link IMatchChecker} implementation class from a {@link Pattern}.
   */
  public List<JvmDeclaredType> inferEvaluatorClass(final Pattern pattern, final String checkerPackageName) {
    ArrayList<JvmDeclaredType> _arrayList = new ArrayList<JvmDeclaredType>();
    final List<JvmDeclaredType> result = _arrayList;
    int patternBodyNumber = 0;
    EList<PatternBody> _bodies = pattern.getBodies();
    for (final PatternBody patternBody : _bodies) {
      {
        int _plus = (patternBodyNumber + 1);
        patternBodyNumber = _plus;
        int checkConstraintNumber = 0;
        EList<Constraint> _constraints = patternBody.getConstraints();
        for (final Constraint constraint : _constraints) {
          if ((constraint instanceof CheckConstraint)) {
            int _plus_1 = (checkConstraintNumber + 1);
            checkConstraintNumber = _plus_1;
            String _plus_2 = (Integer.valueOf(patternBodyNumber) + "_");
            final String postFix = (_plus_2 + Integer.valueOf(checkConstraintNumber));
            final XExpression xExpression = ((CheckConstraint) constraint).getExpression();
            String _evaluatorClassName = this._eMFPatternLanguageJvmModelInferrerUtil.evaluatorClassName(pattern);
            String _plus_3 = (_evaluatorClassName + postFix);
            final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
                public void apply(final JvmGenericType it) {
                  it.setPackageName(checkerPackageName);
                  CharSequence _javadocEvaluatorClass = PatternMatchEvaluatorClassInferrer.this._javadocInferrer.javadocEvaluatorClass(pattern);
                  String _string = _javadocEvaluatorClass.toString();
                  PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                  EList<JvmTypeReference> _superTypes = it.getSuperTypes();
                  JvmTypeReference _newTypeRef = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IMatchChecker.class);
                  PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
                }
              };
            final JvmGenericType checkerClass = this._eMFJvmTypesBuilder.toClass(pattern, _plus_3, _function);
            JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, Boolean.class);
            this.inferEvaluatorClassMethods(checkerClass, pattern, patternBody, xExpression, _newTypeRef);
            result.add(checkerClass);
          }
        }
      }
    }
    return result;
  }
  
  /**
   * Infers methods for checker class based on the input 'pattern'.
   */
  public Boolean inferEvaluatorClassMethods(final JvmDeclaredType checkerClass, final Pattern pattern, final PatternBody body, final XExpression xExpression) {
    Boolean _xblockexpression = null;
    {
      final JvmTypeReference type = this._iTypeProvider.getType(xExpression);
      Boolean _xifexpression = null;
      boolean _notEquals = (!Objects.equal(xExpression, null));
      if (_notEquals) {
        boolean _inferEvaluatorClassMethods = this.inferEvaluatorClassMethods(checkerClass, pattern, body, xExpression, type);
        _xifexpression = Boolean.valueOf(_inferEvaluatorClassMethods);
      }
      _xblockexpression = (_xifexpression);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers methods for checker class based on the input 'pattern'.
   */
  public boolean inferEvaluatorClassMethods(final JvmDeclaredType checkerClass, final Pattern pattern, final PatternBody body, final XExpression xExpression, final JvmTypeReference type) {
    boolean _xblockexpression = false;
    {
      List<Variable> _xifexpression = null;
      boolean _equals = Objects.equal(xExpression, null);
      if (_equals) {
        List<Variable> _emptyList = CollectionLiterals.<Variable>emptyList();
        _xifexpression = _emptyList;
      } else {
        List<Variable> _xblockexpression_1 = null;
        {
          TreeIterator<EObject> _eAllContents = xExpression.eAllContents();
          List<XExpression> _newImmutableList = CollectionLiterals.<XExpression>newImmutableList(xExpression);
          Iterator<XExpression> _iterator = _newImmutableList.iterator();
          Iterator<EObject> _plus = Iterators.<EObject>concat(_eAllContents, _iterator);
          Iterator<XFeatureCall> _filter = Iterators.<XFeatureCall>filter(_plus, XFeatureCall.class);
          final Function1<XFeatureCall,String> _function = new Function1<XFeatureCall,String>() {
              public String apply(final XFeatureCall it) {
                String _concreteSyntaxFeatureName = it.getConcreteSyntaxFeatureName();
                return _concreteSyntaxFeatureName;
              }
            };
          Iterator<String> _map = IteratorExtensions.<XFeatureCall, String>map(_filter, _function);
          final List<String> valNames = IteratorExtensions.<String>toList(_map);
          EList<Variable> _variables = body.getVariables();
          final Function1<Variable,Boolean> _function_1 = new Function1<Variable,Boolean>() {
              public Boolean apply(final Variable it) {
                String _name = it.getName();
                boolean _contains = valNames.contains(_name);
                return Boolean.valueOf(_contains);
              }
            };
          Iterable<Variable> _filter_1 = IterableExtensions.<Variable>filter(_variables, _function_1);
          final Function1<Variable,String> _function_2 = new Function1<Variable,String>() {
              public String apply(final Variable it) {
                String _name = it.getName();
                return _name;
              }
            };
          List<Variable> _sortBy = IterableExtensions.<Variable, String>sortBy(_filter_1, _function_2);
          _xblockexpression_1 = (_sortBy);
        }
        _xifexpression = _xblockexpression_1;
      }
      final List<Variable> variables = _xifexpression;
      EList<JvmMember> _members = checkerClass.getMembers();
      JvmTypeReference _asWrapperTypeIfPrimitive = this._primitives.asWrapperTypeIfPrimitive(type);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            for (final Variable variable : variables) {
              {
                String _name = variable.getName();
                JvmTypeReference _calculateType = PatternMatchEvaluatorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                final JvmFormalParameter parameter = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _name, _calculateType);
                EList<JvmFormalParameter> _parameters = it.getParameters();
                PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, parameter);
              }
            }
            CharSequence _javadocEvaluatorClassGeneratedMethod = PatternMatchEvaluatorClassInferrer.this._javadocInferrer.javadocEvaluatorClassGeneratedMethod(pattern);
            String _string = _javadocEvaluatorClassGeneratedMethod.toString();
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setBody(it, xExpression);
          }
        };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(xExpression, "evaluateXExpressionGenerated", _asWrapperTypeIfPrimitive, _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = checkerClass.getMembers();
      JvmTypeReference _asWrapperTypeIfPrimitive_1 = this._primitives.asWrapperTypeIfPrimitive(type);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmTypeReference _newTypeRef = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Tuple.class);
            JvmFormalParameter _parameter = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "tuple", _newTypeRef);
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            JvmTypeReference _newTypeRef_1 = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
            JvmTypeReference _newTypeRef_2 = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Integer.class);
            JvmTypeReference _newTypeRef_3 = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Map.class, _newTypeRef_1, _newTypeRef_2);
            JvmFormalParameter _parameter_1 = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "tupleNameMap", _newTypeRef_3);
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
            CharSequence _javadocEvaluatorClassWrapperMethod = PatternMatchEvaluatorClassInferrer.this._javadocInferrer.javadocEvaluatorClassWrapperMethod(pattern);
            String _string = _javadocEvaluatorClassWrapperMethod.toString();
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  {
                    for(final Variable variable : variables) {
                      _builder.append("int ");
                      String _name = variable.getName();
                      _builder.append(_name, "");
                      _builder.append("Position = tupleNameMap.get(\"");
                      String _name_1 = variable.getName();
                      _builder.append(_name_1, "");
                      _builder.append("\");");
                      _builder.newLineIfNotEmpty();
                      JvmTypeReference _calculateType = PatternMatchEvaluatorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                      String _qualifiedName = _calculateType.getQualifiedName();
                      _builder.append(_qualifiedName, "");
                      _builder.append(" ");
                      String _name_2 = variable.getName();
                      _builder.append(_name_2, "");
                      _builder.append(" = (");
                      JvmTypeReference _calculateType_1 = PatternMatchEvaluatorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                      String _qualifiedName_1 = _calculateType_1.getQualifiedName();
                      _builder.append(_qualifiedName_1, "");
                      _builder.append(") tuple.get(");
                      String _name_3 = variable.getName();
                      _builder.append(_name_3, "");
                      _builder.append("Position);");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                  _builder.append("return evaluateXExpressionGenerated(");
                  {
                    boolean _hasElements = false;
                    for(final Variable variable_1 : variables) {
                      if (!_hasElements) {
                        _hasElements = true;
                      } else {
                        _builder.appendImmediate(", ", "");
                      }
                      String _name_4 = variable_1.getName();
                      _builder.append(_name_4, "");
                    }
                  }
                  _builder.append(");");
                  it.append(_builder);
                }
              };
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(xExpression, "evaluateXExpression", _asWrapperTypeIfPrimitive_1, _function_1);
      boolean _add = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      _xblockexpression = (_add);
    }
    return _xblockexpression;
  }
}
