/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.impl.BoolValueImpl;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class QueryExplorerPatternRegistry {
    private static QueryExplorerPatternRegistry instance;
    private final Map<IFile, List<Pattern>> registeredPatterModels;
    private final List<Pattern> activePatterns;
    private final Map<String, Pattern> patternNameMap;
    private final ILog logger = IncQueryGUIPlugin.getDefault().getLog();
    private static List<Pattern> generatedPatterns;
    private static Map<Pattern, IQuerySpecification<?>> generatedQuerySpecifications;

    public static synchronized QueryExplorerPatternRegistry getInstance() {
        if (instance == null) {
            instance = new QueryExplorerPatternRegistry();
        }
        return instance;
    }

    protected QueryExplorerPatternRegistry() {
        this.registeredPatterModels = new HashMap<IFile, List<Pattern>>();
        this.patternNameMap = new HashMap<String, Pattern>();
        this.activePatterns = new ArrayList<Pattern>();
    }

    public void addGeneratedPattern(Pattern pattern, String patternFqn) {
        this.patternNameMap.put(patternFqn, pattern);
    }

    public boolean isGenerated(Pattern pattern) {
        return QueryExplorerPatternRegistry.getGeneratedPatterns().contains(pattern);
    }

    public void unregisterPattern(Pattern pattern) {
        String patternFqn = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
        this.patternNameMap.remove(patternFqn);
    }

    public List<Pattern> registerPatternModel(IFile file, PatternModel patternModel) {
        ArrayList<Pattern> newPatterns = new ArrayList<Pattern>();
        if (patternModel != null) {
            ArrayList<Status> warnings = new ArrayList<Status>();
            for (Pattern pattern : patternModel.getPatterns()) {
                String patternFqn = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
                if (!this.patternNameMap.containsKey(patternFqn)) {
                    Boolean annotationValue = QueryExplorerPatternRegistry.getValueOfQueryExplorerAnnotation(pattern);
                    if (annotationValue != null && !annotationValue.booleanValue()) continue;
                    this.patternNameMap.put(patternFqn, pattern);
                    newPatterns.add(pattern);
                    this.activePatterns.add(pattern);
                    continue;
                }
                String message = "A pattern with the fully qualified name '" + patternFqn + "' already exists in the pattern registry.";
                IncQueryException incQueryException = new IncQueryException(message, "Duplicate qualified name of pattern");
                Status status = new Status(2, "org.eclipse.incquery.tooling.ui", message, (Throwable)incQueryException);
                this.logger.log((IStatus)status);
                warnings.add(status);
            }
            if (!warnings.isEmpty()) {
                if (warnings.size() == 1) {
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)"Warning during pattern registration", (IStatus)((IStatus)warnings.get(0)));
                } else {
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.incquery.tooling.ui", 2, warnings.toArray(new IStatus[0]), "Multiple patterns with matching fully qualified names already exist in the pattern registry.", null);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)"Warning during pattern registration", (IStatus)multiStatus);
                }
            }
        }
        if (!newPatterns.isEmpty()) {
            this.registeredPatterModels.put(file, newPatterns);
        }
        return Collections.unmodifiableList(newPatterns);
    }

    public void addActivePattern(Pattern p) {
        if (!this.activePatterns.contains(p)) {
            this.activePatterns.add(p);
        }
    }

    public List<Pattern> getRegisteredPatternsForFile(IFile file) {
        List<Pattern> list = this.registeredPatterModels.get(file);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public boolean isEmpty() {
        return this.registeredPatterModels.isEmpty();
    }

    public List<Pattern> unregisterPatternModel(IFile file) {
        ArrayList<Pattern> removedPatterns = new ArrayList<Pattern>();
        List<Pattern> patterns = this.registeredPatterModels.remove(file);
        if (patterns != null) {
            for (Pattern p : patterns) {
                String patternFqn = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)p);
                if (this.activePatterns.remove(p)) {
                    removedPatterns.add(p);
                }
                this.patternNameMap.remove(patternFqn);
            }
        }
        return Collections.unmodifiableList(removedPatterns);
    }

    public void removeActivePattern(Pattern p) {
        this.activePatterns.remove(p);
    }

    public Pattern getPatternByFqn(String patternFqn) {
        return this.patternNameMap.get(patternFqn);
    }

    public List<Pattern> getActivePatterns() {
        return new ArrayList<Pattern>(this.activePatterns);
    }

    public boolean isActive(String patternFqn) {
        for (Pattern p : this.activePatterns) {
            if (!CorePatternLanguageHelper.getFullyQualifiedName((Pattern)p).matches(patternFqn)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getPatternNames() {
        return Collections.unmodifiableCollection(this.patternNameMap.keySet());
    }

    public List<Pattern> getGenericPatterns() {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (List<Pattern> pm : this.registeredPatterModels.values()) {
            patterns.addAll(pm);
        }
        return Collections.unmodifiableList(patterns);
    }

    public List<Pattern> getAllPatterns() {
        ArrayList<Pattern> r = new ArrayList<Pattern>();
        r.addAll(QueryExplorerPatternRegistry.getGeneratedPatterns());
        r.addAll(this.getGenericPatterns());
        return Collections.unmodifiableList(r);
    }

    public Collection<IFile> getFiles() {
        return Collections.unmodifiableCollection(this.registeredPatterModels.keySet());
    }

    public IFile getFileForPattern(Pattern pattern) {
        if (pattern != null && this.patternNameMap.containsValue(pattern)) {
            for (Map.Entry<IFile, List<Pattern>> entry : this.registeredPatterModels.entrySet()) {
                List<Pattern> patterns = entry.getValue();
                if (patterns.size() <= 0 || !patterns.contains(pattern)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static Boolean getValueOfQueryExplorerAnnotation(Pattern pattern) {
        Annotation annotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)pattern, (String)"QueryExplorer");
        if (annotation == null) {
            return null;
        }
        for (AnnotationParameter ap : annotation.getParameters()) {
            if (!ap.getName().equalsIgnoreCase("display")) continue;
            return ((BoolValueImpl)ap.getValue()).isValue();
        }
        return Boolean.TRUE;
    }

    private static Map<Pattern, IQuerySpecification<?>> collectGeneratedQuerySpecifications() {
        HashMap querySpecifications = new HashMap();
        for (IQuerySpecification querySpecification : QuerySpecificationRegistry.getContributedQuerySpecifications()) {
            Pattern pattern = querySpecification.getPattern();
            Boolean annotationValue = QueryExplorerPatternRegistry.getValueOfQueryExplorerAnnotation(pattern);
            if (annotationValue == null || !annotationValue.booleanValue()) continue;
            querySpecifications.put(pattern, querySpecification);
        }
        return querySpecifications;
    }

    private static synchronized Collection<IQuerySpecification<?>> getGeneratedQuerySpecifications() {
        if (generatedQuerySpecifications == null) {
            generatedQuerySpecifications = QueryExplorerPatternRegistry.collectGeneratedQuerySpecifications();
        }
        return Collections.unmodifiableCollection(generatedQuerySpecifications.values());
    }

    public static synchronized List<Pattern> getGeneratedPatterns() {
        if (generatedPatterns == null) {
            generatedPatterns = QueryExplorerPatternRegistry.collectGeneratedPatterns();
        }
        return Collections.unmodifiableList(generatedPatterns);
    }

    private static List<Pattern> collectGeneratedPatterns() {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (IQuerySpecification<?> querySpecification : QueryExplorerPatternRegistry.getGeneratedQuerySpecifications()) {
            patterns.add(querySpecification.getPattern());
        }
        return patterns;
    }

    public static IQuerySpecification<?> getQuerySpecificationForGeneratedPattern(Pattern pattern) {
        return generatedQuerySpecifications.get(pattern);
    }
}

