/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.specification.GenericQuerySpecification;
import org.eclipse.incquery.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class QueryExplorerPatternRegistry {
    private static final String WARNING_DURING_PATTERN_REGISTRATION = "Warning during pattern registration";
    private static QueryExplorerPatternRegistry instance;
    private final ListMultimap<IFile, IQuerySpecification<?>> registeredPatterModels;
    private final List<IQuerySpecification<?>> activePatterns;
    private final Map<String, IQuerySpecification<?>> patternNameMap;
    private final ILog logger = IncQueryGUIPlugin.getDefault().getLog();
    private SpecificationBuilder builder;

    public static synchronized QueryExplorerPatternRegistry getInstance() {
        if (instance == null) {
            instance = new QueryExplorerPatternRegistry();
        }
        return instance;
    }

    protected QueryExplorerPatternRegistry() {
        this.registeredPatterModels = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<IQuerySpecification<?>>>(){

            public List<IQuerySpecification<?>> get() {
                return Lists.newArrayList();
            }
        });
        this.patternNameMap = new HashMap();
        this.activePatterns = new ArrayList();
        this.builder = new SpecificationBuilder();
    }

    public void addGeneratedPattern(IQuerySpecification<?> specification) {
        this.patternNameMap.put(specification.getFullyQualifiedName(), specification);
    }

    public boolean isGenerated(IQuerySpecification<?> query) {
        return QueryExplorerPatternRegistry.getGeneratedQuerySpecifications().contains(query);
    }

    public List<IQuerySpecification<?>> unregisterPattern(IQuerySpecification<?> specification) {
        ArrayList removedSpecifications = Lists.newArrayList();
        removedSpecifications.add(specification);
        this.patternNameMap.remove(specification.getFullyQualifiedName());
        Set forgottenSpecifications = this.builder.forgetSpecificationTransitively(specification);
        for (IQuerySpecification other : Iterables.filter((Iterable)forgottenSpecifications, (Predicate)Predicates.not((Predicate)Predicates.equalTo(specification)))) {
            removedSpecifications.addAll(this.unregisterPattern(other));
        }
        return removedSpecifications;
    }

    public Set<IQuerySpecification<?>> registerPatternModel(IFile file, PatternModel patternModel) throws IncQueryException {
        ArrayList allCreatedSpecifications = Lists.newArrayList();
        LinkedHashSet activeSpecifications = Sets.newLinkedHashSet();
        if (patternModel != null) {
            ArrayList<Status> warnings = new ArrayList<Status>();
            for (Pattern pattern : patternModel.getPatterns()) {
                IQuerySpecification spec = this.builder.getOrCreateSpecification(pattern, (List)allCreatedSpecifications, false);
                String patternFqn = spec.getFullyQualifiedName();
                if (!this.patternNameMap.containsKey(patternFqn)) {
                    this.patternNameMap.put(patternFqn, spec);
                    this.activePatterns.add(spec);
                    activeSpecifications.add(spec);
                    continue;
                }
                String message = "A pattern with the fully qualified name '" + patternFqn + "' already exists in the pattern registry.";
                IncQueryException incQueryException = new IncQueryException(message, "Duplicate qualified name of pattern");
                Status status = new Status(2, "org.eclipse.incquery.tooling.ui", message, (Throwable)incQueryException);
                this.logger.log((IStatus)status);
                warnings.add(status);
            }
            if (!warnings.isEmpty()) {
                if (warnings.size() == 1) {
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)WARNING_DURING_PATTERN_REGISTRATION, (IStatus)((IStatus)warnings.get(0)));
                } else {
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.incquery.tooling.ui", 2, warnings.toArray(new IStatus[0]), "Multiple patterns with matching fully qualified names already exist in the pattern registry.", null);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)WARNING_DURING_PATTERN_REGISTRATION, (IStatus)multiStatus);
                }
            }
        }
        for (IQuerySpecification createdSpecification : allCreatedSpecifications) {
            IFile dependentFile;
            if (!(createdSpecification instanceof GenericQuerySpecification)) continue;
            GenericQuerySpecification genericSpecification = (GenericQuerySpecification)createdSpecification;
            if (EcoreUtil.isAncestor((EObject)patternModel, (EObject)genericSpecification.getPattern())) {
                this.registeredPatterModels.put((Object)file, (Object)createdSpecification);
                continue;
            }
            URI uri = genericSpecification.getPattern().eResource().getURI();
            if (!uri.isPlatformResource() || !(dependentFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)))).exists()) continue;
            this.registeredPatterModels.put((Object)dependentFile, (Object)genericSpecification);
        }
        return Collections.unmodifiableSet(activeSpecifications);
    }

    public void addActivePattern(IQuerySpecification<?> p) {
        if (!this.activePatterns.contains(p)) {
            this.activePatterns.add(p);
        }
    }

    public List<IQuerySpecification<?>> getRegisteredPatternsForFile(IFile file) {
        List list = this.registeredPatterModels.get((Object)file);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public boolean isEmpty() {
        return this.registeredPatterModels.isEmpty();
    }

    public List<IQuerySpecification<?>> unregisterPatternModel(IFile file) {
        ArrayList removedPatterns = Lists.newArrayList();
        List patterns = this.registeredPatterModels.get((Object)file);
        if (patterns != null) {
            for (IQuerySpecification p : patterns) {
                try {
                    String patternFqn = p.getFullyQualifiedName();
                    if (this.activePatterns.remove(p)) {
                        removedPatterns.add(p);
                    }
                    this.patternNameMap.remove(patternFqn);
                    this.builder.forgetSpecificationTransitively(p);
                }
                catch (Exception e) {
                    this.logger.log((IStatus)new Status(2, "org.eclipse.incquery.tooling.ui", "Error while unregistering the pattern", (Throwable)e));
                }
            }
        }
        return removedPatterns;
    }

    public void removeActivePattern(IQuerySpecification<?> p) {
        this.activePatterns.remove(p);
    }

    public void removeActivePattern(String patternFqn) {
        this.removeActivePattern(this.getPatternByFqn(patternFqn));
    }

    public IQuerySpecification<?> getPatternByFqn(String patternFqn) {
        return this.patternNameMap.get(patternFqn);
    }

    public List<IQuerySpecification<?>> getActivePatterns() {
        return Lists.newArrayList(this.activePatterns);
    }

    public boolean isActive(String patternFqn) {
        for (IQuerySpecification<?> p : this.activePatterns) {
            if (!p.getFullyQualifiedName().matches(patternFqn)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getPatternNames() {
        return Collections.unmodifiableCollection(this.patternNameMap.keySet());
    }

    public Collection<IQuerySpecification<?>> getGenericQuerySpecifications() {
        return Collections.unmodifiableCollection(this.registeredPatterModels.values());
    }

    public List<IQuerySpecification<?>> getAllPatterns() {
        return ImmutableList.builder().addAll(QueryExplorerPatternRegistry.getGeneratedQuerySpecifications()).addAll(this.getGenericQuerySpecifications()).build();
    }

    public Collection<IFile> getFiles() {
        return Collections.unmodifiableCollection(this.registeredPatterModels.keySet());
    }

    public IFile getFileForPattern(IQuerySpecification<?> pattern) {
        if (pattern != null && this.patternNameMap.containsValue(pattern)) {
            for (Map.Entry entry : this.registeredPatterModels.entries()) {
                if (!pattern.equals(entry.getValue())) continue;
                return (IFile)entry.getKey();
            }
        }
        return null;
    }

    public static boolean isQueryExplorerCheckedFalse(IQuerySpecification<?> query) {
        Object checkedValue;
        PAnnotation annotation = query.getFirstAnnotationByName("QueryExplorer");
        return annotation != null && (checkedValue = annotation.getFirstValue("checked")) != null && (Boolean)checkedValue == false;
    }

    public static synchronized ImmutableList<IQuerySpecification<?>> getGeneratedQuerySpecifications() {
        return ImmutableList.builder().addAll(Iterables.filter((Iterable)QuerySpecificationRegistry.getContributedQuerySpecifications(), (Predicate)new Predicate<IQuerySpecification<?>>(){

            public boolean apply(IQuerySpecification<?> input) {
                return true;
            }
        })).build();
    }
}

