package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.PackageOwnedStereotypeMatch;
import org.eclipse.uml2.uml.Stereotype;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.packageOwnedStereotype pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class PackageOwnedStereotypeProcessor implements IMatchProcessor<PackageOwnedStereotypeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pTemp2 the value of pattern parameter temp2 in the currently processed match
   * 
   */
  public abstract void process(final org.eclipse.uml2.uml.Package pSelf, final Stereotype pTemp2);
  
  @Override
  public void process(final PackageOwnedStereotypeMatch match) {
    process(match.getSelf(), match.getTemp2());
  }
}
