package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.PackageVisibleMemberMatch;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.packageVisibleMember pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class PackageVisibleMemberProcessor implements IMatchProcessor<PackageVisibleMemberMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pPackage_ the value of pattern parameter package_ in the currently processed match
   * @param pVisibleMember the value of pattern parameter visibleMember in the currently processed match
   * 
   */
  public abstract void process(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember);
  
  @Override
  public void process(final PackageVisibleMemberMatch match) {
    process(match.getPackage_(), match.getVisibleMember());
  }
}
