package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.VertexIncomingMatch;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.vertexIncoming pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class VertexIncomingProcessor implements IMatchProcessor<VertexIncomingMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pTemp1 the value of pattern parameter temp1 in the currently processed match
   * 
   */
  public abstract void process(final Vertex pSelf, final Transition pTemp1);
  
  @Override
  public void process(final VertexIncomingMatch match) {
    process(match.getSelf(), match.getTemp1());
  }
}
