package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ActivityEdgeInGroupMatch;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityGroup;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.activityEdgeInGroup pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ActivityEdgeInGroupProcessor implements IMatchProcessor<ActivityEdgeInGroupMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final ActivityEdge pSource, final ActivityGroup pTarget);
  
  @Override
  public void process(final ActivityEdgeInGroupMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
