package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.ActivityNodeInGroupMatch;
import org.eclipse.incquery.uml.derivedfeatures.ActivityNodeInGroupMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.ActivityGroupContainedNodeQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate ActivityNodeInGroupMatcher in a type-safe way.
 * 
 * @see ActivityNodeInGroupMatcher
 * @see ActivityNodeInGroupMatch
 * 
 */
@SuppressWarnings("all")
public final class ActivityNodeInGroupQuerySpecification extends BaseGeneratedEMFQuerySpecification<ActivityNodeInGroupMatcher> {
  private ActivityNodeInGroupQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ActivityNodeInGroupQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ActivityNodeInGroupMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return ActivityNodeInGroupMatcher.on(engine);
  }
  
  @Override
  public ActivityNodeInGroupMatch newEmptyMatch() {
    return ActivityNodeInGroupMatch.newEmptyMatch();
  }
  
  @Override
  public ActivityNodeInGroupMatch newMatch(final Object... parameters) {
    return ActivityNodeInGroupMatch.newMatch((org.eclipse.uml2.uml.ActivityNode) parameters[0], (org.eclipse.uml2.uml.ActivityGroup) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static ActivityNodeInGroupQuerySpecification INSTANCE = make();
    
    public static ActivityNodeInGroupQuerySpecification make() {
      return new ActivityNodeInGroupQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ActivityNodeInGroupQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.activityNodeInGroup";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","target");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("source", "org.eclipse.uml2.uml.ActivityNode"),new PParameter("target", "org.eclipse.uml2.uml.ActivityGroup"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		new TypeConstraint(body, new FlatTuple(var_source), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ActivityNode")));
      		new TypeConstraint(body, new FlatTuple(var_target), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ActivityGroup")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, "source"),
      		   new ExportedParameter(body, var_target, "target")
      		));
      		//     // opposite of ActivityGroup.containedNode    find activityGroupContainedNode(target, source)
      		new PositivePatternCall(body, new FlatTuple(var_target, var_source), ActivityGroupContainedNodeQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("Surrogate");
      		annotation.addAttribute("feature", "inGroup");
      		addAnnotation(annotation);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
