package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierParentsMatch;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierParentsMatcher;

/**
 * A pattern-specific query specification that can instantiate ClassifierParentsMatcher in a type-safe way.
 * 
 * @see ClassifierParentsMatcher
 * @see ClassifierParentsMatch
 * 
 */
@SuppressWarnings("all")
public final class ClassifierParentsQuerySpecification extends BaseGeneratedEMFQuerySpecification<ClassifierParentsMatcher> {
  private ClassifierParentsQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ClassifierParentsQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ClassifierParentsMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return ClassifierParentsMatcher.on(engine);
  }
  
  @Override
  public ClassifierParentsMatch newEmptyMatch() {
    return ClassifierParentsMatch.newEmptyMatch();
  }
  
  @Override
  public ClassifierParentsMatch newMatch(final Object... parameters) {
    return ClassifierParentsMatch.newMatch((org.eclipse.uml2.uml.Classifier) parameters[0], (org.eclipse.uml2.uml.Classifier) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static ClassifierParentsQuerySpecification INSTANCE = make();
    
    public static ClassifierParentsQuerySpecification make() {
      return new ClassifierParentsQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ClassifierParentsQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.classifierParents";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","classifier");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Classifier"),new PParameter("classifier", "org.eclipse.uml2.uml.Classifier"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_self = body.getOrCreateVariableByName("self");
      		PVariable var_classifier = body.getOrCreateVariableByName("classifier");
      		PVariable var_generalization = body.getOrCreateVariableByName("generalization");
      		PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Classifier")));
      		new TypeConstraint(body, new FlatTuple(var_classifier), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Classifier")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_self, "self"),
      		   new ExportedParameter(body, var_classifier, "classifier")
      		));
      		//     Classifier.generalization(self, generalization)
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Classifier")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_self, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Classifier", "generalization")));
      		new Equality(body, var__virtual_0_, var_generalization);
      		//     temp1 == generalization
      		new Equality(body, var_temp1, var_generalization);
      		//     Generalization.general(temp1, classifier)
      		new TypeConstraint(body, new FlatTuple(var_temp1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Generalization")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_temp1, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Generalization", "general")));
      		new Equality(body, var__virtual_1_, var_classifier);
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
