package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.VertexOutgoingMatch;
import org.eclipse.incquery.uml.derivedfeatures.VertexOutgoingMatcher;

/**
 * A pattern-specific query specification that can instantiate VertexOutgoingMatcher in a type-safe way.
 * 
 * @see VertexOutgoingMatcher
 * @see VertexOutgoingMatch
 * 
 */
@SuppressWarnings("all")
public final class VertexOutgoingQuerySpecification extends BaseGeneratedEMFQuerySpecification<VertexOutgoingMatcher> {
  private VertexOutgoingQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static VertexOutgoingQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected VertexOutgoingMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return VertexOutgoingMatcher.on(engine);
  }
  
  @Override
  public VertexOutgoingMatch newEmptyMatch() {
    return VertexOutgoingMatch.newEmptyMatch();
  }
  
  @Override
  public VertexOutgoingMatch newMatch(final Object... parameters) {
    return VertexOutgoingMatch.newMatch((org.eclipse.uml2.uml.Vertex) parameters[0], (org.eclipse.uml2.uml.Transition) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static VertexOutgoingQuerySpecification INSTANCE = make();
    
    public static VertexOutgoingQuerySpecification make() {
      return new VertexOutgoingQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static VertexOutgoingQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.vertexOutgoing";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","temp1");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Vertex"),new PParameter("temp1", "org.eclipse.uml2.uml.Transition"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_self = body.getOrCreateVariableByName("self");
      		PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      		PVariable var_vertex = body.getOrCreateVariableByName("vertex");
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Vertex")));
      		new TypeConstraint(body, new FlatTuple(var_temp1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Transition")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_self, "self"),
      		   new ExportedParameter(body, var_temp1, "temp1")
      		));
      		//     Transition.source(temp1, vertex)
      		new TypeConstraint(body, new FlatTuple(var_temp1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Transition")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_temp1, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Transition", "source")));
      		new Equality(body, var__virtual_0_, var_vertex);
      		//     vertex == self
      		new Equality(body, var_vertex, var_self);
      		//     Transition(transition)
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Transition")));
      		//     temp1 == transition
      		new Equality(body, var_temp1, var_transition);
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("Surrogate");
      		annotation.addAttribute("feature", "outgoing");
      		addAnnotation(annotation);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
