/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.base.comprehension.EMFVisitor;
import org.eclipse.incquery.runtime.base.core.NavigationHelperContentAdapter;
import org.eclipse.incquery.runtime.base.core.NavigationHelperImpl;

public abstract class NavigationHelperVisitor
extends EMFVisitor {
    protected NavigationHelperImpl navigationHelper;
    private final NavigationHelperContentAdapter store;
    boolean isInsertion;
    boolean descendHierarchy;

    NavigationHelperVisitor(NavigationHelperImpl navigationHelper, boolean isInsertion, boolean descendHierarchy) {
        super(isInsertion);
        this.navigationHelper = navigationHelper;
        this.store = navigationHelper.getContentAdapter();
        this.isInsertion = isInsertion;
        this.descendHierarchy = descendHierarchy;
    }

    @Override
    public boolean pruneSubtrees(EObject source) {
        return !this.descendHierarchy;
    }

    @Override
    public boolean pruneSubtrees(Resource source) {
        return !this.descendHierarchy;
    }

    @Override
    public boolean pruneFeature(EStructuralFeature feature) {
        if (this.observesFeature(feature)) {
            return false;
        }
        if (feature instanceof EAttribute && this.observesDataType(((EAttribute)feature).getEAttributeType())) {
            return false;
        }
        return !this.isInsertion || !this.navigationHelper.isExpansionAllowed() || !(feature instanceof EReference) || ((EReference)feature).isContainment();
    }

    protected abstract boolean observesFeature(EStructuralFeature var1);

    protected abstract boolean observesDataType(EDataType var1);

    protected abstract boolean observesClass(EClass var1);

    @Override
    public void visitElement(EObject source) {
        EClass eClass = source.eClass();
        if (eClass.eIsProxy()) {
            eClass = (EClass)EcoreUtil.resolve((EObject)eClass, (EObject)source);
        }
        this.store.maintainMetamodel((EClassifier)eClass);
        if (this.observesClass(eClass)) {
            if (this.isInsertion) {
                this.store.insertIntoInstanceSet(eClass, source);
            } else {
                this.store.removeFromInstanceSet(eClass, source);
            }
        }
    }

    @Override
    public void visitAttribute(EObject source, EAttribute feature, Object target) {
        EDataType eAttributeType = feature.getEAttributeType();
        if (this.observesFeature((EStructuralFeature)feature)) {
            if (this.isInsertion) {
                this.store.insertFeatureTuple((EStructuralFeature)feature, target, source);
            } else {
                this.store.removeFeatureTuple((EStructuralFeature)feature, target, source);
            }
        }
        if (this.observesDataType(eAttributeType)) {
            if (this.isInsertion) {
                this.store.insertIntoDataTypeMap(eAttributeType, target);
            } else {
                this.store.removeFromDataTypeMap(eAttributeType, target);
            }
        }
    }

    @Override
    public void visitInternalContainment(EObject source, EReference feature, EObject target) {
        this.visitReference(source, feature, target);
    }

    @Override
    public void visitNonContainmentReference(EObject source, EReference feature, EObject target) {
        this.visitReference(source, feature, target);
        if (this.isInsertion) {
            this.navigationHelper.considerForExpansion(target);
        }
    }

    private void visitReference(EObject source, EReference feature, EObject target) {
        if (this.observesFeature((EStructuralFeature)feature)) {
            if (this.isInsertion) {
                this.store.insertFeatureTuple((EStructuralFeature)feature, target, source);
            } else {
                this.store.removeFeatureTuple((EStructuralFeature)feature, target, source);
            }
        }
    }

    @Override
    public void visitUnresolvableProxyFeature(EObject source, EReference reference, EObject target) {
        this.store.suspendVisitorOnUnresolvableFeature(this, source, reference, target, this.isInsertion);
    }

    @Override
    public void visitUnresolvableProxyObject(EObject source) {
        this.store.suspendVisitorOnUnresolvableObject(this, source, this.isInsertion);
    }

    @Override
    public boolean forceProxyResolution() {
        return this.isInsertion;
    }

    public static class ChangeVisitor
    extends NavigationHelperVisitor {
        private final boolean wildcardMode;
        private final Set<EClass> allObservedClasses;
        private final Set<EDataType> observedDataTypes;
        private final Set<EStructuralFeature> observedFeatures;

        public ChangeVisitor(NavigationHelperImpl navigationHelper, boolean isInsertion) {
            super(navigationHelper, isInsertion, false);
            this.wildcardMode = navigationHelper.isInWildcardMode();
            this.allObservedClasses = navigationHelper.getAllObservedClasses();
            this.observedDataTypes = navigationHelper.getObservedDataTypes();
            this.observedFeatures = navigationHelper.getObservedFeatures();
        }

        @Override
        protected boolean observesClass(EClass eClass) {
            return this.wildcardMode || this.allObservedClasses.contains(eClass);
        }

        @Override
        protected boolean observesDataType(EDataType type) {
            return this.wildcardMode || this.observedDataTypes.contains(type);
        }

        @Override
        protected boolean observesFeature(EStructuralFeature feature) {
            return this.wildcardMode || this.observedFeatures.contains(feature);
        }
    }

    public static class TraversingVisitor
    extends NavigationHelperVisitor {
        private final boolean wildcardMode;
        Set<EStructuralFeature> features;
        Set<EClass> newClasses;
        Set<EClass> oldClasses;
        Map<EClass, Boolean> classObservationMap;
        Set<EDataType> dataTypes;

        public TraversingVisitor(NavigationHelperImpl navigationHelper, Set<EStructuralFeature> features, Set<EClass> newClasses, Set<EClass> oldClasses, Set<EDataType> dataTypes) {
            super(navigationHelper, true, true);
            this.wildcardMode = navigationHelper.isInWildcardMode();
            this.features = features;
            this.newClasses = newClasses;
            this.oldClasses = oldClasses;
            this.classObservationMap = new HashMap<EClass, Boolean>();
            this.dataTypes = dataTypes;
        }

        @Override
        protected boolean observesClass(EClass eClass) {
            if (this.navigationHelper.isInWildcardMode()) {
                return true;
            }
            Boolean observed = this.classObservationMap.get(eClass);
            if (observed == null) {
                EList eAllSuperTypes = eClass.getEAllSuperTypes();
                boolean overApprox = this.newClasses.contains(eClass) || this.newClasses.contains(NavigationHelperContentAdapter.EOBJECT_CLASS) || !Collections.disjoint(eAllSuperTypes, this.newClasses);
                observed = overApprox && !this.oldClasses.contains(eClass) && !this.oldClasses.contains(NavigationHelperContentAdapter.EOBJECT_CLASS) && Collections.disjoint(eAllSuperTypes, this.oldClasses);
                this.classObservationMap.put(eClass, observed);
            }
            return observed;
        }

        @Override
        protected boolean observesDataType(EDataType type) {
            return this.wildcardMode || this.dataTypes.contains(type);
        }

        @Override
        protected boolean observesFeature(EStructuralFeature feature) {
            return this.wildcardMode || this.features.contains(feature);
        }
    }
}

