/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.ConflictResolver;
import org.eclipse.incquery.runtime.evm.api.ConflictSet;
import org.eclipse.incquery.runtime.evm.api.RuleBase;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.api.event.EventType;
import org.eclipse.incquery.runtime.evm.notification.IActivationNotificationListener;

public class Agenda {
    private Multimap<ActivationState, Activation<?>> activations;
    private ConflictSet conflictSet;
    private final IActivationNotificationListener activationListener;
    private final RuleBase ruleBase;

    public Agenda(RuleBase ruleBase, ConflictResolver<?> conflictResolver) {
        this.ruleBase = ruleBase;
        this.activations = HashMultimap.create();
        this.conflictSet = conflictResolver.createConflictSet();
        this.activationListener = new DefaultActivationNotificationListener();
    }

    public Multimap<ActivationState, Activation<?>> getActivations() {
        return this.activations;
    }

    public Collection<Activation<?>> getActivations(ActivationState state) {
        return this.getActivations().get((Object)state);
    }

    public Collection<Activation<?>> getAllActivations() {
        return this.getActivations().values();
    }

    public Activation<?> getNextActivation() {
        return this.conflictSet.getNextActivation();
    }

    public Set<Activation<?>> getNextActivations() {
        return this.conflictSet.getNextActivations();
    }

    public Set<Activation<?>> getConflictingActivations() {
        return this.conflictSet.getConflictingActivations();
    }

    public IActivationNotificationListener getActivationListener() {
        return this.activationListener;
    }

    public void setConflictResolver(ConflictResolver<?> resolver) {
        Object set = resolver.createConflictSet();
        for (Activation<?> act : this.conflictSet.getConflictingActivations()) {
            set.addActivation(act);
        }
        this.conflictSet = set;
    }

    private final class DefaultActivationNotificationListener
    implements IActivationNotificationListener {
        private DefaultActivationNotificationListener() {
        }

        @Override
        public void activationChanged(Activation<?> activation, ActivationState oldState, EventType event) {
            Agenda.this.ruleBase.getLogger().debug((Object)String.format("%s -- %s --> %s on %s", oldState, event, activation.getState(), activation));
            Agenda.this.getActivations().remove((Object)oldState, activation);
            ActivationState state = activation.getState();
            if (state.isInactive()) {
                Agenda.this.conflictSet.removeActivation(activation);
            } else {
                this.refreshActivation(activation, state);
            }
        }

        @Override
        public void activationCreated(Activation<?> activation, ActivationState inactiveState) {
            Agenda.this.ruleBase.getLogger().debug((Object)String.format("%s -- CREATE --> %s on %s", inactiveState, activation.getState(), activation));
            ActivationState state = activation.getState();
            this.refreshActivation(activation, state);
        }

        @Override
        public void activationRemoved(Activation<?> activation, ActivationState oldState) {
            Agenda.this.ruleBase.getLogger().debug((Object)String.format("%s -- REMOVE --> %s on %s", oldState, activation.getState(), activation));
            Agenda.this.getActivations().remove((Object)oldState, activation);
            Agenda.this.conflictSet.removeActivation(activation);
        }

        private void refreshActivation(Activation<?> activation, ActivationState state) {
            if (activation.isEnabled()) {
                Agenda.this.conflictSet.addActivation(activation);
            } else {
                Agenda.this.conflictSet.removeActivation(activation);
            }
            Agenda.this.getActivations().put((Object)state, activation);
        }
    }
}

