package org.eclipse.incquery.tooling.core.generator.builder.xmi;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguageFactory;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ImportDeclaration;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidationDiagnostics;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidator;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternValidationStatus;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternURIHandler;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

/**
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class XmiModelBuilder {
  @Inject
  private Logger logger;
  
  @Inject
  private PatternSetValidator validator;
  
  /**
   * Builds one model file (XMI) from the input into the folder.
   */
  public void build(final ResourceSet resourceSet, final String fileFullPath) {
    try {
      final PatternModel xmiModelRoot = EMFPatternLanguageFactory.eINSTANCE.createPatternModel();
      URI _createPlatformResourceURI = URI.createPlatformResourceURI(fileFullPath, true);
      final Resource xmiResource = resourceSet.createResource(_createPlatformResourceURI);
      final HashSet<EPackage> importDeclarations = CollectionLiterals.<EPackage>newHashSet();
      EList<Resource> _resources = resourceSet.getResources();
      ArrayList<Resource> _arrayList = new ArrayList<Resource>(_resources);
      final ArrayList<Resource> resources = _arrayList;
      for (final Resource r : resources) {
        EList<EObject> _contents = r.getContents();
        for (final EObject obj : _contents) {
          boolean _and = false;
          if (!(obj instanceof PatternModel)) {
            _and = false;
          } else {
            boolean _equals = obj.equals(xmiModelRoot);
            boolean _not = (!_equals);
            _and = ((obj instanceof PatternModel) && _not);
          }
          if (_and) {
            Iterable<PackageImport> _packageImportsIterable = EMFPatternLanguageHelper.getPackageImportsIterable(((PatternModel) obj));
            for (final PackageImport importDecl : _packageImportsIterable) {
              {
                final EPackage ePackage = importDecl.getEPackage();
                boolean _and_1 = false;
                boolean _and_2 = false;
                boolean _notEquals = (!Objects.equal(ePackage, null));
                if (!_notEquals) {
                  _and_2 = false;
                } else {
                  boolean _eIsProxy = ePackage.eIsProxy();
                  boolean _not_1 = (!_eIsProxy);
                  _and_2 = (_notEquals && _not_1);
                }
                if (!_and_2) {
                  _and_1 = false;
                } else {
                  boolean _contains = importDeclarations.contains(ePackage);
                  boolean _not_2 = (!_contains);
                  _and_1 = (_and_2 && _not_2);
                }
                if (_and_1) {
                  importDeclarations.add(ePackage);
                }
              }
            }
          }
        }
      }
      EList<ImportDeclaration> _importPackages = xmiModelRoot.getImportPackages();
      final Function1<EPackage,PackageImport> _function = new Function1<EPackage,PackageImport>() {
          public PackageImport apply(final EPackage it) {
            final PackageImport imp = EMFPatternLanguageFactory.eINSTANCE.createPackageImport();
            imp.setEPackage(it);
            return imp;
          }
        };
      Iterable<PackageImport> _map = IterableExtensions.<EPackage, PackageImport>map(importDeclarations, _function);
      Iterables.<ImportDeclaration>addAll(_importPackages, _map);
      final Map<String,Pattern> fqnToPatternMap = CollectionLiterals.<String, Pattern>newHashMap();
      final Function1<Resource,Iterable<Pattern>> _function_1 = new Function1<Resource,Iterable<Pattern>>() {
          public Iterable<Pattern> apply(final Resource r) {
            TreeIterator<EObject> _allContents = r.getAllContents();
            Iterable<EObject> _iterable = IteratorExtensions.<EObject>toIterable(_allContents);
            Iterable<Pattern> _filter = Iterables.<Pattern>filter(_iterable, Pattern.class);
            return _filter;
          }
        };
      List<Iterable<Pattern>> _map_1 = ListExtensions.<Resource, Iterable<Pattern>>map(resources, _function_1);
      Iterable<Pattern> _flatten = Iterables.<Pattern>concat(_map_1);
      for (final Pattern pattern : _flatten) {
        PatternSetValidationDiagnostics _validateTransitively = this.validator.validateTransitively(pattern);
        PatternValidationStatus _status = _validateTransitively.getStatus();
        boolean _notEquals = (!Objects.equal(_status, PatternValidationStatus.ERROR));
        if (_notEquals) {
          this.copyPattern(pattern, fqnToPatternMap, xmiModelRoot);
        }
      }
      TreeIterator<EObject> _eAllContents = xmiModelRoot.eAllContents();
      Iterable<EObject> _iterable = IteratorExtensions.<EObject>toIterable(_eAllContents);
      Iterable<PatternCall> _filter = Iterables.<PatternCall>filter(_iterable, PatternCall.class);
      for (final PatternCall call : _filter) {
        {
          Pattern _patternRef = call.getPatternRef();
          final String fqn = CorePatternLanguageHelper.getFullyQualifiedName(_patternRef);
          final Pattern p = fqnToPatternMap.get(fqn);
          boolean _equals_1 = Objects.equal(p, null);
          if (_equals_1) {
            String _plus = ("Pattern not found: " + fqn);
            this.logger.error(_plus);
          } else {
            call.setPatternRef(((Pattern) p));
          }
        }
      }
      EList<EObject> _contents_1 = xmiResource.getContents();
      _contents_1.add(xmiModelRoot);
      EMFPatternURIHandler _eMFPatternURIHandler = new EMFPatternURIHandler(importDeclarations);
      Pair<String,EMFPatternURIHandler> _mappedTo = Pair.<String, EMFPatternURIHandler>of(XMLResource.OPTION_URI_HANDLER, _eMFPatternURIHandler);
      final HashMap<String,EMFPatternURIHandler> options = CollectionLiterals.<String, EMFPatternURIHandler>newHashMap(_mappedTo);
      xmiResource.save(options);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        this.logger.error("Exception during XMI build!", e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public void copyPattern(final Pattern pattern, final Map<String,Pattern> fqnToPatternMap, final PatternModel xmiModelRoot) {
    Pattern _copy = EcoreUtil2.<Pattern>copy(pattern);
    final Pattern p = ((Pattern) _copy);
    final String fqn = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    p.setName(fqn);
    Resource _eResource = pattern.eResource();
    URI _uRI = _eResource.getURI();
    String _string = _uRI.toString();
    p.setFileName(_string);
    Pattern _get = fqnToPatternMap.get(fqn);
    boolean _notEquals = (!Objects.equal(_get, null));
    if (_notEquals) {
      String _plus = ("Pattern already set in the Map: " + fqn);
      this.logger.error(_plus);
    } else {
      fqnToPatternMap.put(fqn, p);
      EList<Pattern> _patterns = xmiModelRoot.getPatterns();
      _patterns.add(p);
    }
    EList<PatternBody> _bodies = p.getBodies();
    for (final PatternBody body : _bodies) {
      {
        final HashMap<Object,Object> nameToLocalVariableParameterMap = CollectionLiterals.<Object, Object>newHashMap();
        EList<Variable> _variables = body.getVariables();
        for (final Variable variable : _variables) {
          {
            final String vfqn = variable.getName();
            Object _get_1 = nameToLocalVariableParameterMap.get(vfqn);
            boolean _notEquals_1 = (!Objects.equal(_get_1, null));
            if (_notEquals_1) {
              String _plus_1 = ("Variable already set in the Map: " + vfqn);
              this.logger.error(_plus_1);
            } else {
              nameToLocalVariableParameterMap.put(vfqn, variable);
            }
          }
        }
        TreeIterator<EObject> _eAllContents = body.eAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.<EObject>toIterable(_eAllContents);
        Iterable<XFeatureCall> _filter = Iterables.<XFeatureCall>filter(_iterable, XFeatureCall.class);
        for (final XFeatureCall expression : _filter) {
          {
            final JvmIdentifiableElement f = expression.getFeature();
            if ((f instanceof Variable)) {
              final String vfqn = ((Variable) f).getName();
              final Object v = nameToLocalVariableParameterMap.get(vfqn);
              boolean _equals = Objects.equal(v, null);
              if (_equals) {
                String _plus_1 = ("Variable not found: " + vfqn);
                this.logger.error(_plus_1);
              } else {
                expression.setFeature(((Variable) v));
              }
            }
          }
        }
      }
    }
  }
}
