package org.eclipse.incquery.tooling.core.generator.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.CheckConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Constraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.extensibility.IMatchChecker;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.tooling.core.generator.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/**
 * {@link IMatchChecker} implementation inferer.
 */
@SuppressWarnings("all")
public class PatternMatchEvaluatorClassInferrer {
  @Inject
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  private ITypeProvider _iTypeProvider;
  
  @Inject
  private Primitives _primitives;
  
  /**
   * Infers the {@link IMatchChecker} implementation class from a {@link Pattern}.
   */
  public List<JvmDeclaredType> inferEvaluatorClass(final Pattern pattern, final String checkerPackageName) {
    ArrayList<JvmDeclaredType> _arrayList = new ArrayList<JvmDeclaredType>();
    final List<JvmDeclaredType> result = _arrayList;
    int patternBodyNumber = 0;
    EList<PatternBody> _bodies = pattern.getBodies();
    for (final PatternBody patternBody : _bodies) {
      {
        int _plus = (patternBodyNumber + 1);
        patternBodyNumber = _plus;
        int checkConstraintNumber = 0;
        EList<Constraint> _constraints = patternBody.getConstraints();
        for (final Constraint constraint : _constraints) {
          if ((constraint instanceof CheckConstraint)) {
            int _plus_1 = (checkConstraintNumber + 1);
            checkConstraintNumber = _plus_1;
            String _plus_2 = (Integer.valueOf(patternBodyNumber) + "_");
            final String postFix = (_plus_2 + Integer.valueOf(checkConstraintNumber));
            final XExpression xExpression = ((CheckConstraint) constraint).getExpression();
            String _evaluatorClassName = this._eMFPatternLanguageJvmModelInferrerUtil.evaluatorClassName(pattern);
            String _plus_3 = (_evaluatorClassName + postFix);
            final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
                public void apply(final JvmGenericType it) {
                  it.setPackageName(checkerPackageName);
                  CharSequence _javadocEvaluatorClass = PatternMatchEvaluatorClassInferrer.this._javadocInferrer.javadocEvaluatorClass(pattern);
                  String _string = _javadocEvaluatorClass.toString();
                  PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                  EList<JvmTypeReference> _superTypes = it.getSuperTypes();
                  JvmTypeReference _newTypeRef = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IMatchChecker.class);
                  PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
                }
              };
            final JvmGenericType checkerClass = this._eMFJvmTypesBuilder.toClass(pattern, _plus_3, _function);
            JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, Boolean.class);
            this.inferEvaluatorClassMethods(checkerClass, pattern, xExpression, _newTypeRef);
            result.add(checkerClass);
          }
        }
      }
    }
    return result;
  }
  
  /**
   * Infers methods for checker class based on the input 'pattern'.
   */
  public boolean inferEvaluatorClassMethods(final JvmDeclaredType checkerClass, final Pattern pattern, final XExpression xExpression) {
    boolean _xblockexpression = false;
    {
      final JvmTypeReference type = this._iTypeProvider.getType(xExpression);
      boolean _xifexpression = false;
      boolean _notEquals = (!Objects.equal(xExpression, null));
      if (_notEquals) {
        boolean _inferEvaluatorClassMethods = this.inferEvaluatorClassMethods(checkerClass, pattern, xExpression, type);
        _xifexpression = _inferEvaluatorClassMethods;
      }
      _xblockexpression = (_xifexpression);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers methods for checker class based on the input 'pattern'.
   */
  public boolean inferEvaluatorClassMethods(final JvmDeclaredType checkerClass, final Pattern pattern, final XExpression xExpression, final JvmTypeReference type) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = checkerClass.getMembers();
      JvmTypeReference _asWrapperTypeIfPrimitive = this._primitives.asWrapperTypeIfPrimitive(type);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            Set<Variable> _referencedPatternVariablesOfXExpression = CorePatternLanguageHelper.getReferencedPatternVariablesOfXExpression(xExpression);
            for (final Variable variable : _referencedPatternVariablesOfXExpression) {
              EList<JvmFormalParameter> _parameters = it.getParameters();
              String _name = variable.getName();
              JvmTypeReference _calculateType = PatternMatchEvaluatorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
              JvmFormalParameter _parameter = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _name, _calculateType);
              PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            }
            CharSequence _javadocEvaluatorClassGeneratedMethod = PatternMatchEvaluatorClassInferrer.this._javadocInferrer.javadocEvaluatorClassGeneratedMethod(pattern);
            String _string = _javadocEvaluatorClassGeneratedMethod.toString();
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setBody(it, xExpression);
          }
        };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "evaluateXExpressionGenerated", _asWrapperTypeIfPrimitive, _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = checkerClass.getMembers();
      JvmTypeReference _asWrapperTypeIfPrimitive_1 = this._primitives.asWrapperTypeIfPrimitive(type);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmTypeReference _newTypeRef = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Tuple.class);
            JvmFormalParameter _parameter = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "tuple", _newTypeRef);
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            JvmTypeReference _newTypeRef_1 = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
            JvmTypeReference _newTypeRef_2 = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Integer.class);
            JvmTypeReference _newTypeRef_3 = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Map.class, _newTypeRef_1, _newTypeRef_2);
            JvmFormalParameter _parameter_1 = PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "tupleNameMap", _newTypeRef_3);
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
            CharSequence _javadocEvaluatorClassWrapperMethod = PatternMatchEvaluatorClassInferrer.this._javadocInferrer.javadocEvaluatorClassWrapperMethod(pattern);
            String _string = _javadocEvaluatorClassWrapperMethod.toString();
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  {
                    Set<Variable> _referencedPatternVariablesOfXExpression = CorePatternLanguageHelper.getReferencedPatternVariablesOfXExpression(xExpression);
                    for(final Variable variable : _referencedPatternVariablesOfXExpression) {
                      _builder.append("int ");
                      String _name = variable.getName();
                      _builder.append(_name, "");
                      _builder.append("Position = tupleNameMap.get(\"");
                      String _name_1 = variable.getName();
                      _builder.append(_name_1, "");
                      _builder.append("\");");
                      _builder.newLineIfNotEmpty();
                      JvmTypeReference _calculateType = PatternMatchEvaluatorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                      String _qualifiedName = _calculateType.getQualifiedName();
                      _builder.append(_qualifiedName, "");
                      _builder.append(" ");
                      String _name_2 = variable.getName();
                      _builder.append(_name_2, "");
                      _builder.append(" = (");
                      JvmTypeReference _calculateType_1 = PatternMatchEvaluatorClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                      String _qualifiedName_1 = _calculateType_1.getQualifiedName();
                      _builder.append(_qualifiedName_1, "");
                      _builder.append(") tuple.get(");
                      String _name_3 = variable.getName();
                      _builder.append(_name_3, "");
                      _builder.append("Position);");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                  _builder.append("return evaluateXExpressionGenerated(");
                  {
                    Set<Variable> _referencedPatternVariablesOfXExpression_1 = CorePatternLanguageHelper.getReferencedPatternVariablesOfXExpression(xExpression);
                    boolean _hasElements = false;
                    for(final Variable variable_1 : _referencedPatternVariablesOfXExpression_1) {
                      if (!_hasElements) {
                        _hasElements = true;
                      } else {
                        _builder.appendImmediate(", ", "");
                      }
                      String _name_4 = variable_1.getName();
                      _builder.append(_name_4, "");
                    }
                  }
                  _builder.append(");");
                  it.append(_builder);
                }
              };
            PatternMatchEvaluatorClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "evaluateXExpression", _asWrapperTypeIfPrimitive_1, _function_1);
      boolean _add = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      _xblockexpression = (_add);
    }
    return _xblockexpression;
  }
}
