/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.patternregistry.views;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.incquery.runtime.patternregistry.IPatternInfo;
import org.eclipse.incquery.runtime.patternregistry.PatternRegistry;
import org.eclipse.incquery.tooling.ui.patternregistry.handlers.RegisterHandlersUtil;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class ResourceChangeListener
implements IResourceChangeListener {
    private final IResourceSetProvider resourceSetProvider;

    public ResourceChangeListener(IResourceSetProvider resourceSetProvider) {
        this.resourceSetProvider = resourceSetProvider;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        List relatedIPatternInfoList = PatternRegistry.INSTANCE.getPatternInfosByFile(file);
                        if (!relatedIPatternInfoList.isEmpty()) {
                            if (delta.getKind() == 4) {
                                for (IPatternInfo patternInfo : relatedIPatternInfoList) {
                                    PatternRegistry.INSTANCE.removePatternFromRegistry(patternInfo);
                                }
                                RegisterHandlersUtil.registerSingleFile(file, ResourceChangeListener.this.resourceSetProvider);
                            } else if (delta.getKind() == 2) {
                                for (IPatternInfo patternInfo : relatedIPatternInfoList) {
                                    PatternRegistry.INSTANCE.removePatternFromRegistry(patternInfo);
                                }
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

