/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternGroup;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.evm.api.ConflictResolver;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.resolver.FixedPriorityConflictResolver;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.converters.ContainmentList;
import org.eclipse.incquery.viewers.runtime.model.converters.EdgeList;
import org.eclipse.incquery.viewers.runtime.model.converters.ItemConverter;

public class ViewerDataModel {
    private static final int NODE_PRIORITY = 0;
    private static final int EDGE_PRIORITY = 1;
    private static final int CONTAINMENT_PRIORITY = 2;
    private IncQueryEngine engine;
    private Logger logger;
    private ResourceSet model;
    private Set<Pattern> patterns;
    private Multimap<Object, Item> itemMap;
    private RuleEngine ruleEngine;
    private FixedPriorityConflictResolver resolver;

    public ViewerDataModel(ResourceSet model, IPatternGroup group, IncQueryEngine engine) {
        this(model, group.getPatterns(), engine);
    }

    public ViewerDataModel(ResourceSet model, Collection<Pattern> patterns, IncQueryEngine engine) {
        this.model = model;
        this.patterns = Sets.newHashSet(patterns);
        this.engine = engine;
        this.itemMap = this.initializeItemMap();
        this.logger = engine.getLogger();
        this.ruleEngine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)engine));
        this.resolver = new FixedPriorityConflictResolver();
        this.ruleEngine.setConflictResolver((ConflictResolver)this.resolver);
    }

    private Multimap<Object, Item> initializeItemMap() {
        HashMap map = Maps.newHashMap();
        return Multimaps.newListMultimap((Map)map, (Supplier)new Supplier<List<Item>>(){

            public List<Item> get() {
                ArrayList list = Lists.newArrayList();
                return new WritableList((List)list, Item.class);
            }
        });
    }

    public IncQueryEngine getEngine() {
        return this.engine;
    }

    public ResourceSet getModel() {
        return this.model;
    }

    public Collection<Pattern> getPatterns(String annotation) {
        return this.patterns;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public IObservableList initializeObservableItemList() {
        return this.initializeObservableItemList(ViewerDataFilter.UNFILTERED);
    }

    public IObservableList initializeObservableItemList(ViewerDataFilter filter) {
        this.itemMap = this.initializeItemMap();
        ArrayList<WritableList> nodeListsObservable = new ArrayList<WritableList>();
        for (Pattern nodePattern : this.getPatterns("Item")) {
            DataBindingContext ctx = new DataBindingContext();
            ViewerDataFilter.MatchList<IPatternMatch> nodeList = filter.getObservableList(nodePattern, this.ruleEngine);
            this.resolver.setPriority(nodeList.getSpecification(), 0);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)nodePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)nodePattern, (String)"Item")) {
                WritableList resultList = new WritableList();
                nodeListsObservable.add(resultList);
                ctx.bindList((IObservableList)resultList, nodeList, null, new UpdateListStrategy().setConverter((IConverter)new ItemConverter(this.itemMap, annotation, formatAnnotation)));
            }
        }
        MultiList list = new MultiList((IObservableList[])nodeListsObservable.toArray(new ObservableList[nodeListsObservable.size()]));
        list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleRemove(int index, Object element) {
                        if (element instanceof Item) {
                            Item item = (Item)element;
                            Object paramObject = item.getParamObject();
                            ViewerDataModel.this.itemMap.remove(paramObject, element);
                        }
                    }

                    public void handleAdd(int index, Object element) {
                        if (element instanceof Item) {
                            Item item = (Item)element;
                            ViewerDataModel.this.itemMap.put(item.getParamObject(), (Object)item);
                        }
                    }
                });
            }
        });
        return list;
    }

    public MultiList initializeObservableEdgeList() {
        return this.initializeObservableEdgeList(ViewerDataFilter.UNFILTERED);
    }

    public MultiList initializeObservableEdgeList(ViewerDataFilter filter) {
        ArrayList<EdgeList> edgeListsObservable = new ArrayList<EdgeList>();
        for (Pattern edgePattern : this.getPatterns("Edge")) {
            ViewerDataFilter.MatchList<IPatternMatch> edgelist = filter.getObservableList(edgePattern, this.ruleEngine);
            this.resolver.setPriority(edgelist.getSpecification(), 1);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)edgePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)edgePattern, (String)"Edge")) {
                EdgeList resultList = new EdgeList(annotation, formatAnnotation, this.itemMap, (IObservableList)edgelist);
                edgeListsObservable.add(resultList);
            }
        }
        MultiList list = new MultiList(edgeListsObservable.toArray(new IObservableList[edgeListsObservable.size()]));
        return list;
    }

    public MultiList initializeObservableContainmentList() {
        return this.initializeObservableContainmentList(ViewerDataFilter.UNFILTERED);
    }

    public MultiList initializeObservableContainmentList(ViewerDataFilter filter) {
        ArrayList<ContainmentList> containmentListsObservable = new ArrayList<ContainmentList>();
        for (Pattern containmentPattern : this.getPatterns("ContainsItem")) {
            ViewerDataFilter.MatchList<IPatternMatch> containmentList = filter.getObservableList(containmentPattern, this.ruleEngine);
            this.resolver.setPriority(containmentList.getSpecification(), 2);
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)containmentPattern, (String)"ContainsItem")) {
                ContainmentList resultList = new ContainmentList(annotation, this.itemMap, (IObservableList)containmentList);
                containmentListsObservable.add(resultList);
            }
        }
        MultiList list = new MultiList(containmentListsObservable.toArray(new IObservableList[containmentListsObservable.size()]));
        return list;
    }

    public Collection<Item> getItemsFor(EObject target) {
        return this.itemMap.get((Object)target);
    }
}

