/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.ui.handlers;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.viatra.addon.querybyexample.ui.QBEViewUtils;
import org.eclipse.viatra.addon.querybyexample.ui.ui.QBEView;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;

public abstract class AbstractEObjectSelectionHandler
extends AbstractHandler {
    public static final String QBE_COMMON_ALERT_TITLE = "Error";
    private static final String QBE_NO_EOBJECTS_IN_SELECTION_ERROR = "There are no EObjects in the active selection!";

    protected abstract void handleSelection(QBEView var1, Collection<EObject> var2);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IModelConnector selectionProvider;
        Collection selectedEObjects;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        QBEView qbeView = QBEViewUtils.getQBEView(event);
        ISelection selection = editor.getEditorSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            qbeView.setSelection((IStructuredSelection)selection);
        }
        if ((selectedEObjects = (selectionProvider = this.getSelectionProviderFromIEditorPart(editor)).getSelectedEObjects()) == null || selectedEObjects.isEmpty()) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)QBE_COMMON_ALERT_TITLE, (String)QBE_NO_EOBJECTS_IN_SELECTION_ERROR);
            return null;
        }
        this.handleSelection(qbeView, selectedEObjects);
        QBEViewUtils.getMainSourceProvider(event).setModelLoadedState();
        return null;
    }

    private IModelConnector getSelectionProviderFromIEditorPart(IEditorPart editorPart) {
        if (editorPart != null) {
            Object adaptedObject = editorPart.getAdapter(IModelConnector.class);
            if (adaptedObject != null) {
                return (IModelConnector)adaptedObject;
            }
            Platform.getAdapterManager().loadAdapter((Object)editorPart, IModelConnector.class.getName());
            adaptedObject = editorPart.getAdapter(IModelConnector.class);
            if (adaptedObject != null) {
                return (IModelConnector)adaptedObject;
            }
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.viatra.addon.querybyexample.ui", 4, "Adapted object (Model Connector instance) not found.", (Throwable)new IllegalStateException()));
        }
        return null;
    }
}

