/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.ui.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.viatra.addon.querybyexample.interfaces.ICodeGenerator;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLNegConstraint;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElement;
import org.eclipse.viatra.addon.querybyexample.ui.model.properties.QBEViewElementNegativeConstraintProperties;
import org.eclipse.viatra.addon.querybyexample.ui.ui.QBEView;

public class QBEViewElementConstraint
extends QBEViewElement {
    private VQLConstraint constraint;
    private ICodeGenerator codeGenerator;
    private QBEView container;
    private static final ImageDescriptor constraintImg = ImageDescriptor.createFromFile(QBEViewElementConstraint.class, (String)"/icons/qbe_constraint.gif");
    private static final ImageDescriptor constraintImgNeg = ImageDescriptor.createFromFile(QBEViewElementConstraint.class, (String)"/icons/qbe_constraint_disabled.gif");
    private static final ImageDescriptor negconstraintImg = ImageDescriptor.createFromFile(QBEViewElementConstraint.class, (String)"/icons/qbe_constraint_neg.gif");
    private static final ImageDescriptor negconstraintImgNeg = ImageDescriptor.createFromFile(QBEViewElementConstraint.class, (String)"/icons/qbe_constraint_neg_disabled.gif");

    public QBEViewElementConstraint(VQLConstraint constraint, ICodeGenerator codeGenerator, QBEView container) {
        this.constraint = constraint;
        this.codeGenerator = codeGenerator;
        this.container = container;
    }

    public VQLConstraint getConstraint() {
        return this.constraint;
    }

    public QBEView getContainer() {
        return this.container;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (this.constraint instanceof VQLNegConstraint) {
            return this.constraint.isVisible() ? negconstraintImg : negconstraintImgNeg;
        }
        return this.constraint.isVisible() ? constraintImg : constraintImgNeg;
    }

    public String getLabel(Object o) {
        if (this.constraint instanceof VQLNegConstraint) {
            return this.codeGenerator.generateNegConstraintFind((VQLNegConstraint)this.constraint);
        }
        return this.codeGenerator.generateConstraint(this.constraint);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        if (adapter == IPropertySource.class && this.constraint instanceof VQLNegConstraint) {
            return new QBEViewElementNegativeConstraintProperties(this);
        }
        return null;
    }
}

