/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.ui.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.viatra.addon.querybyexample.interfaces.ICodeGenerator;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLPath;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElement;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementConstraint;
import org.eclipse.viatra.addon.querybyexample.ui.model.properties.QBEViewElementPathProperties;
import org.eclipse.viatra.addon.querybyexample.ui.ui.QBEView;

public class QBEViewElementPath
extends QBEViewElement {
    private VQLPath path;
    private ICodeGenerator codeGenerator;
    private QBEView container;
    private static final ImageDescriptor pathImg = ImageDescriptor.createFromFile(QBEViewElementConstraint.class, (String)"/icons/qbe_path.gif");
    private static final ImageDescriptor pathImgNeg = ImageDescriptor.createFromFile(QBEViewElementConstraint.class, (String)"/icons/qbe_path_disabled.gif");
    private static final String VIEWELEMENT_PATH_LABEL_PREFIX = "Path ";

    public QBEViewElementPath(QBEView container, VQLPath path, ICodeGenerator codeGenerator) {
        this.container = container;
        this.path = path;
        this.codeGenerator = codeGenerator;
        for (VQLConstraint constraint : path.getConstraints()) {
            QBEViewElementConstraint newElement = new QBEViewElementConstraint(constraint, codeGenerator, container);
            newElement.setParent(this);
            this.children.add(newElement);
        }
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.path.isVisible() ? pathImg : pathImgNeg;
    }

    public String getLabel(Object o) {
        return VIEWELEMENT_PATH_LABEL_PREFIX + this.codeGenerator.generatePathLabel(this.path);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new QBEViewElementPathProperties(this);
        }
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public VQLPath getPath() {
        return this.path;
    }

    public QBEView getContainer() {
        return this.container;
    }
}

