/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.ui.model.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.viatra.addon.querybyexample.ui.QBEViewUtils;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementVariable;
import org.eclipse.viatra.addon.querybyexample.ui.ui.CheckBoxPropertyDescriptor;

public class QBEViewElementVariableProperties
implements IPropertySource {
    private QBEViewElementVariable element;
    private boolean isAnchor;
    private static final String PROPERTY_TEXT = "org.eclipse.viatra.addon.querybyexample.view.model.properties.QBEViewElementVariableProperties:text";
    private static final String PROPERTY_CHECKBOX = "org.eclipse.viatra.addon.querybyexample.view.model.properties.QBEViewElementVariableProperties:checkbox";
    private static final String PROPERTY_CHECKBOX_INPUTVAR = "org.eclipse.viatra.addon.querybyexample.view.model.properties.QBEViewElementVariableProperties:checkboxinputvar";
    private static final String PROPERTY_COMBO = "org.eclipse.viatra.addon.querybyexample.view.model.properties.QBEViewElementVariableProperties:combo";
    private static final String VARIABLE_NAME_PROPERTIES_LBL = "Variable Name";
    private static final String IS_VISIBLE_PROPERTIES_LBL = "Included as local variable constraint";
    private static final String TYPE_PROPERTIES_LBL = "Type";
    private static final String INPUTVAR_PROPERTIES_LBL = "Local variable as input parameter";
    private static final String ERROR_DIALOG_TITLE = "Validation error";
    private static final String ERROR_DIALOG_MAIN_TEXT = "Invalid variable name";
    private Map<Integer, EClass> typesMap;

    public QBEViewElementVariableProperties(QBEViewElementVariable element) {
        this.element = element;
        this.isAnchor = element.isAnchor();
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        this.typesMap = new HashMap<Integer, EClass>();
        Set types = this.element.getContainer().getService().getSuperTypeList(this.element.getEo());
        ArrayList<String> typeNames = new ArrayList<String>();
        int i = 0;
        for (EClass ec : types) {
            this.typesMap.put(i++, ec);
            typeNames.add(ec.getName());
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)PROPERTY_TEXT, VARIABLE_NAME_PROPERTIES_LBL);
        descriptor.setCategory("Basic");
        ComboBoxPropertyDescriptor descriptorCombo = new ComboBoxPropertyDescriptor((Object)PROPERTY_COMBO, TYPE_PROPERTIES_LBL, typeNames.toArray(new String[typeNames.size()]));
        descriptorCombo.setCategory("Basic");
        descriptorCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object el) {
                if (el instanceof Integer) {
                    int integerElement = (Integer)el;
                    return ((EClass)QBEViewElementVariableProperties.this.typesMap.get(integerElement)).getName();
                }
                return null;
            }
        });
        ret.add(descriptor);
        ret.add(descriptorCombo);
        if (!this.isAnchor) {
            CheckBoxPropertyDescriptor checkBoxDescriptorInputVar = new CheckBoxPropertyDescriptor(PROPERTY_CHECKBOX_INPUTVAR, INPUTVAR_PROPERTIES_LBL);
            checkBoxDescriptorInputVar.setCategory("Basic");
            ret.add((Object)checkBoxDescriptorInputVar);
            if (!this.element.getVariableSetting().isInputVariable()) {
                CheckBoxPropertyDescriptor checkBoxDescriptor = new CheckBoxPropertyDescriptor(PROPERTY_CHECKBOX, IS_VISIBLE_PROPERTIES_LBL);
                checkBoxDescriptor.setCategory("Basic");
                ret.add((Object)checkBoxDescriptor);
            }
        }
        return ret.toArray(new IPropertyDescriptor[ret.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (PROPERTY_CHECKBOX.equals(id)) {
            return this.element.getVariableSetting().isVisible();
        }
        if (PROPERTY_CHECKBOX_INPUTVAR.equals(id)) {
            return this.element.getVariableSetting().isInputVariable();
        }
        if (PROPERTY_TEXT.equals(id)) {
            return this.element.getVariableSetting().getVariableName();
        }
        if (PROPERTY_COMBO.equals(id)) {
            for (Map.Entry<Integer, EClass> typesEntry : this.typesMap.entrySet()) {
                if (!this.element.getVariableSetting().getType().equals(typesEntry.getValue())) continue;
                return typesEntry.getKey();
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_CHECKBOX.equals(id)) {
            this.element.getVariableSetting().setVisible(((Boolean)value).booleanValue());
        }
        if (PROPERTY_CHECKBOX_INPUTVAR.equals(id)) {
            boolean b = (Boolean)value;
            this.element.getVariableSetting().setInputVariable(b);
            if (b) {
                this.element.getVariableSetting().setVisible(b);
            }
        }
        if (PROPERTY_TEXT.equals(id)) {
            String strValue = (String)value;
            if (QBEViewUtils.checkVariableNameIsReserved(strValue)) {
                strValue = "^" + strValue;
            } else if (!QBEViewUtils.validatePropertyName(strValue)) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ERROR_DIALOG_TITLE, (String)ERROR_DIALOG_MAIN_TEXT);
                return;
            }
            this.element.getVariableSetting().setVariableName(strValue);
        }
        if (PROPERTY_COMBO.equals(id) && value instanceof Integer) {
            this.element.getVariableSetting().setType(this.typesMap.get((Integer)value));
        }
        this.element.getContainer().updateViewer();
    }
}

