/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.ui.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra.addon.querybyexample.interfaces.ICodeGenerator;
import org.eclipse.viatra.addon.querybyexample.interfaces.IQBEService;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLAttribute;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLNegConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLPath;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLVariableSetting;
import org.eclipse.viatra.addon.querybyexample.services.QBEServiceImpl;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElement;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementAttribute;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementConstraint;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementNsUri;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementPackage;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementPath;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementPattern;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementPatternContainer;
import org.eclipse.viatra.addon.querybyexample.ui.model.QBEViewElementVariable;

public class QBEView
extends ViewPart {
    public static final String ID = "org.eclipse.viatra.addon.querybyexample.view.qbeview";
    private static final String GROUP_TITLE = "Exploration depth";
    private TreeViewer viewer;
    private Text depthDisplayText;
    private Scale explorationDepthScale;
    private IStructuredSelection selection;
    private QBEViewElementPackage packageNameModel;
    private QBEViewElementNsUri nsUriModel;
    private QBEViewElementPattern patternModel;
    private IQBEService service;
    private ICodeGenerator codeGenerator;
    private int defaultDepth = 1;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 10;
        composite.setLayout((Layout)layout);
        Group explorationGroup = new Group(composite, 0);
        explorationGroup.setText(GROUP_TITLE);
        explorationGroup.setLayout((Layout)layout);
        explorationGroup.setLayoutData((Object)new GridData(4, 1, true, false, 10, 1));
        this.explorationDepthScale = new Scale((Composite)explorationGroup, 0);
        this.explorationDepthScale.setMinimum(1);
        this.explorationDepthScale.setMaximum(20);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 8;
        this.explorationDepthScale.setLayoutData((Object)gridData);
        this.explorationDepthScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int value = QBEView.this.explorationDepthScale.getSelection();
                QBEView.this.depthDisplayText.setText(Integer.toString(value));
                if (QBEView.this.service != null) {
                    QBEView.this.service.explore(value);
                    QBEView.this.updateViewer();
                }
            }
        });
        this.depthDisplayText = new Text((Composite)explorationGroup, 2052);
        this.depthDisplayText.setEditable(false);
        gridData = new GridData(4, 0x1000000, true, false);
        this.depthDisplayText.setLayoutData((Object)gridData);
        this.autoAdjust();
        this.viewer = new TreeViewer(composite);
        GridData viewerGridData = new GridData(4, 4, true, true);
        viewerGridData.horizontalSpan = 10;
        this.viewer.getControl().setLayoutData((Object)viewerGridData);
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput((Object)this.getInitialInput());
        this.viewer.expandAll();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void start(Collection<EObject> selection) {
        if (this.service == null) {
            this.service = new QBEServiceImpl();
        }
        this.service.init(selection);
        this.reInitialize();
    }

    public void expand(Collection<EObject> selection) {
        if (this.service == null) {
            this.service = new QBEServiceImpl();
        }
        HashSet<EObject> newSelection = new HashSet<EObject>();
        newSelection.addAll(selection);
        newSelection.addAll(this.service.getSelection());
        this.service.init(newSelection);
        this.reInitialize();
    }

    private void reInitialize() {
        this.codeGenerator = this.service.getCodeGenerator();
        int coherenceDepth = this.service.determineCoherenceMinimumDepth();
        this.defaultDepth = coherenceDepth == 0 ? 1 : coherenceDepth;
        this.autoAdjust();
    }

    public IQBEService getService() {
        return this.service;
    }

    public void autoAdjust() {
        this.explorationDepthScale.setSelection(this.defaultDepth);
        this.explorationDepthScale.notifyListeners(13, new Event());
    }

    private QBEViewElement getInitialInput() {
        QBEViewElement root = new QBEViewElement(){

            public ImageDescriptor getImageDescriptor(Object object) {
                return null;
            }

            public String getLabel(Object o) {
                return null;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
        root.setParent(root);
        this.packageNameModel = new QBEViewElementPackage(this);
        this.packageNameModel.setParent(root);
        root.getChildren().add(this.packageNameModel);
        this.nsUriModel = new QBEViewElementNsUri();
        this.nsUriModel.setParent(root);
        root.getChildren().add(this.nsUriModel);
        this.patternModel = new QBEViewElementPattern(this);
        this.patternModel.setParent(root);
        root.getChildren().add(this.patternModel);
        return root;
    }

    public void updateViewer() {
        String packageName = this.service.getPackageName();
        String nsUri = this.service.getNsUri();
        String patternName = this.service.getPatternName();
        this.packageNameModel.setPackageName(packageName);
        this.nsUriModel.setNsUri(nsUri);
        this.patternModel.setPatternName(patternName);
        QBEViewElementPatternContainer inputParamsContainter = this.patternModel.getInputParamsContainer();
        inputParamsContainter.getChildren().clear();
        Map anchors = this.service.getAnchors();
        for (Map.Entry anchorEntry : anchors.entrySet()) {
            QBEViewElementVariable newAnchor = new QBEViewElementVariable(this, (EObject)anchorEntry.getKey(), (VQLVariableSetting)anchorEntry.getValue(), true);
            inputParamsContainter.addNewElement(newAnchor);
        }
        QBEViewElementPatternContainer localVariableConstraintsContainer = this.patternModel.getLocalVariableConstraintsContainer();
        QBEViewElementPatternContainer constraintsContainer = this.patternModel.getConstraintsContainer();
        QBEViewElementPatternContainer pathsContainer = this.patternModel.getPathsContainer();
        QBEViewElementPatternContainer attributesContainer = this.patternModel.getAttributesContainer();
        QBEViewElementPatternContainer negativeConstraintsContainer = this.patternModel.getNegativeConstraintsContainer();
        localVariableConstraintsContainer.getChildren().clear();
        constraintsContainer.getChildren().clear();
        attributesContainer.getChildren().clear();
        pathsContainer.getChildren().clear();
        negativeConstraintsContainer.getChildren().clear();
        Map freeVariables = this.service.getFreeVariables();
        for (Map.Entry freeVarEntry : freeVariables.entrySet()) {
            QBEViewElementVariable qBEViewElementVariable = new QBEViewElementVariable(this, (EObject)freeVarEntry.getKey(), (VQLVariableSetting)freeVarEntry.getValue(), false);
            if (((VQLVariableSetting)freeVarEntry.getValue()).isInputVariable()) {
                inputParamsContainter.addNewElement(qBEViewElementVariable);
                continue;
            }
            localVariableConstraintsContainer.addNewElement(qBEViewElementVariable);
        }
        Set constraints = this.service.getConstraints();
        ArrayList<Object> invisibleConstraintElements = new ArrayList<Object>();
        for (VQLConstraint vQLConstraint : constraints) {
            QBEViewElementConstraint newConstraint = new QBEViewElementConstraint(vQLConstraint, this.codeGenerator, this);
            if (vQLConstraint.isVisible()) {
                constraintsContainer.addNewElement(newConstraint);
                continue;
            }
            invisibleConstraintElements.add(newConstraint);
        }
        for (QBEViewElementConstraint qBEViewElementConstraint : invisibleConstraintElements) {
            constraintsContainer.addNewElement(qBEViewElementConstraint);
        }
        Set set = this.service.getNegConstraints();
        for (VQLNegConstraint eiqnc : set) {
            QBEViewElementConstraint newNegConstraint = new QBEViewElementConstraint((VQLConstraint)eiqnc, this.codeGenerator, this);
            negativeConstraintsContainer.addNewElement(newNegConstraint);
        }
        this.viewer.expandAll();
        List paths = this.service.getPaths();
        for (VQLPath eiqPath : paths) {
            pathsContainer.addNewElement(new QBEViewElementPath(this, eiqPath, this.codeGenerator));
        }
        List eiqAttributes = this.service.getAttributes();
        for (VQLAttribute eiqAttr : eiqAttributes) {
            attributesContainer.addNewElement(new QBEViewElementAttribute(this, eiqAttr, this.codeGenerator));
        }
        this.viewer.refresh();
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }
}

