/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.ui.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.viatra.addon.querybyexample.ui.QBEViewUtils;
import org.eclipse.viatra.addon.querybyexample.ui.handlers.QBEViewMainSourceProvider;
import org.eclipse.viatra.addon.querybyexample.ui.ui.QBEView;
import org.eclipse.viatra.addon.querybyexample.ui.ui.WizardNewEIQFileCreation;

public class RefreshCodeDialog
extends Dialog {
    private static final String REFRESH_CODE_DIALOG_TITLE = "Save generated pattern to...";
    private static final String RADIO_LABEL_TWO = "New .vql file inside an existing VIATRA project";
    private static final String RADIO_LABEL_THREE = "Existing .vql file (will be overwritten!)";
    private static final String RADIO_LABEL_FOUR = "Clipboard";
    private static final String OPEN_RESOURCE_DIALOG_TITLE = "Choose existing .vql file to be overwritten";
    private static final String VQL_FILE_EXTENSION = "vql";
    private Button radioButtonOne;
    private Button radioButtonTwo;
    private Button radioButtonThree;
    private QBEView qbeView;
    private QBEViewMainSourceProvider provider;

    public RefreshCodeDialog(Shell parentShell, QBEView view, QBEViewMainSourceProvider provider) {
        super(parentShell);
        this.qbeView = view;
        this.provider = provider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 15;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        this.radioButtonOne = new Button(container, 16);
        this.radioButtonOne.setText(RADIO_LABEL_TWO);
        this.radioButtonOne.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.radioButtonTwo = new Button(container, 16);
        this.radioButtonTwo.setText(RADIO_LABEL_THREE);
        this.radioButtonTwo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.radioButtonThree = new Button(container, 16);
        this.radioButtonThree.setText(RADIO_LABEL_FOUR);
        return container;
    }

    protected Point getInitialSize() {
        return new Point(375, 175);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(REFRESH_CODE_DIALOG_TITLE);
    }

    protected void okPressed() {
        String code;
        String string = code = this.qbeView == null || this.qbeView.getService() == null ? null : this.qbeView.getService().getPatternCode();
        if (code != null) {
            if (this.radioButtonOne.getSelection()) {
                this.performNewFileExistingProjectAction(code);
            } else if (this.radioButtonTwo.getSelection()) {
                this.performExistingFileAction(code);
            } else if (this.radioButtonThree.getSelection()) {
                this.performClipboardAction(code);
            }
        }
        super.okPressed();
    }

    private void performNewFileExistingProjectAction(String code) {
        if (this.qbeView.getSelection() != null) {
            WizardNewEIQFileCreation newFileWizard = new WizardNewEIQFileCreation(code, this.provider);
            newFileWizard.init(PlatformUI.getWorkbench(), this.qbeView.getSelection());
            WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)newFileWizard);
            wizardDialog.open();
        } else {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.viatra.addon.querybyexample.ui", 4, "Active selection not found.", (Throwable)new IllegalStateException()));
        }
    }

    private void performExistingFileAction(String code) {
        IFile[] files;
        EIQFilesViewerFilter eiqFilesFilter = new EIQFilesViewerFilter();
        ArrayList<EIQFilesViewerFilter> eiqFilesFilterList = new ArrayList<EIQFilesViewerFilter>();
        eiqFilesFilterList.add(eiqFilesFilter);
        IFile[] iFileArray = files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), (String)OPEN_RESOURCE_DIALOG_TITLE, (String)"", (boolean)false, null, eiqFilesFilterList);
        if (files.length != 0) {
            IFile f = iFileArray[0];
            try {
                f.setContents((InputStream)new ByteArrayInputStream(code.getBytes()), true, false, null);
                QBEViewUtils.setLinkedFile(f);
                this.provider.setLinkedFileExistingState();
            }
            catch (CoreException ex) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.viatra.addon.querybyexample.ui", 4, ex.getMessage(), (Throwable)ex));
            }
        }
    }

    private void performClipboardAction(String code) {
        new Clipboard(null).setContents(new Object[]{code}, new Transfer[]{TextTransfer.getInstance()});
    }

    private static class EIQFilesViewerFilter
    extends ViewerFilter {
        private EIQFilesViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof IFile) || RefreshCodeDialog.VQL_FILE_EXTENSION.equals(((IFile)element).getFileExtension());
        }
    }
}

