/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.ui.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.viatra.addon.querybyexample.ui.QBEViewUtils;
import org.eclipse.viatra.addon.querybyexample.ui.handlers.QBEViewMainSourceProvider;

public class WizardNewEIQFileCreation
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private String code;
    private WizardNewFileCreationPage newFileWizardPage;
    private QBEViewMainSourceProvider qbeViewMainSourceProvider;
    private static final String WIZARD_WINDOW_TITLE = "New VIATRA Query Definition";
    private static final String WIZARD_PAGE_TITLE = "VIATRA QBE Query Definition Wizard";
    private static final String WIZARD_PAGE_DESCRIPTION = "Create a new VIATRA Query Definition file";
    private static final String WIZARD_PAGE_NAME = "org.eclipse.viatra.addon.querybyexample.view.ui.WizardNewEIQFileCreation:newFileWizardPage";
    private static final String WIZARD_PAGE_EIQ_FILE_EXTENSION = "vql";

    public WizardNewEIQFileCreation(String code, QBEViewMainSourceProvider provider) {
        this.setWindowTitle(WIZARD_WINDOW_TITLE);
        this.code = code;
        this.setHelpAvailable(false);
        this.qbeViewMainSourceProvider = provider;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.newFileWizardPage = new WizardNewFileCreationPage(WIZARD_PAGE_NAME, this.selection);
        this.newFileWizardPage.setTitle(WIZARD_PAGE_TITLE);
        this.newFileWizardPage.setDescription(WIZARD_PAGE_DESCRIPTION);
        this.newFileWizardPage.setFileExtension(WIZARD_PAGE_EIQ_FILE_EXTENSION);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.newFileWizardPage);
    }

    public boolean performFinish() {
        IFile file = this.newFileWizardPage.createNewFile();
        if (file != null) {
            try {
                file.setContents((InputStream)new ByteArrayInputStream(this.code.getBytes()), true, false, null);
                QBEViewUtils.setLinkedFile(file);
                this.qbeViewMainSourceProvider.setLinkedFileExistingState();
                return true;
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.viatra.addon.querybyexample.ui", 4, e.getMessage(), (Throwable)e));
            }
        }
        return false;
    }
}

