/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.code;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLVariableSetting;

public class VariableRegister {
    private Map<String, Integer> classNameCounter = new HashMap<String, Integer>();
    private Map<EObject, VQLVariableSetting> fixVariables = new HashMap<EObject, VQLVariableSetting>();
    private Map<EObject, VQLVariableSetting> freeVariables = new HashMap<EObject, VQLVariableSetting>();

    public void registerFixVariable(EObject eo) {
        if (this.fixVariables.containsKey(eo)) {
            return;
        }
        String className = eo.eClass().getName().toLowerCase();
        Integer count = this.classNameCounter.get(className);
        int newCount = count == null ? 0 : count + 1;
        this.classNameCounter.put(className, newCount);
        VQLVariableSetting varSetting = new VQLVariableSetting();
        varSetting.setInputVariable(true);
        varSetting.setVariableName(String.valueOf(className) + Integer.toString(newCount));
        varSetting.setType(eo.eClass());
        this.fixVariables.put(eo, varSetting);
    }

    public void registerFreeVariable(EObject eo) {
        if (this.freeVariables.containsKey(eo)) {
            return;
        }
        String className = eo.eClass().getName().toLowerCase();
        Integer count = this.classNameCounter.get(className);
        int newCount = count == null ? 0 : count + 1;
        this.classNameCounter.put(className, newCount);
        VQLVariableSetting varSetting = new VQLVariableSetting();
        varSetting.setInputVariable(false);
        varSetting.setVariableName(String.valueOf(className) + Integer.toString(newCount));
        varSetting.setType(eo.eClass());
        this.freeVariables.put(eo, varSetting);
    }

    public VQLVariableSetting getVariableSetting(EObject eo) {
        VQLVariableSetting ret = this.fixVariables.get(eo);
        if (ret == null) {
            ret = this.freeVariables.get(eo);
        }
        return ret;
    }

    public void reset() {
        this.classNameCounter.clear();
        this.freeVariables.clear();
        for (EObject eo : this.fixVariables.keySet()) {
            String className = eo.eClass().getName().toLowerCase();
            Integer count = this.classNameCounter.get(className);
            int newCount = count == null ? 0 : count + 1;
            this.classNameCounter.put(className, newCount);
        }
    }

    public Map<EObject, VQLVariableSetting> getFixVariables() {
        return this.fixVariables;
    }

    public Map<EObject, VQLVariableSetting> getFreeVariables() {
        return this.freeVariables;
    }
}

