/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.exploration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.addon.querybyexample.code.VariableRegister;
import org.eclipse.viatra.addon.querybyexample.interfaces.IExplorer;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLAttribute;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLNegConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLPath;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLPattern;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;

public class ExplorerImpl
implements IExplorer {
    private static final int NO_LONGER_DISCOVER_LIMIT = 20;
    private VQLPattern pattern;
    private VariableRegister variableRegister;
    private NavigationHelper navigationHelper;

    public ExplorerImpl(Set<EObject> selectedEObjects, NavigationHelper nh, VariableRegister register) {
        this.navigationHelper = nh;
        this.variableRegister = register;
        for (EObject selectedEObject : selectedEObjects) {
            this.variableRegister.registerFixVariable(selectedEObject);
        }
        this.pattern = new VQLPattern(selectedEObjects);
        for (EObject eo : selectedEObjects) {
            this.pattern.getAttributes().addAll(this.getAttributesForEObject(eo));
        }
    }

    @Override
    public void explore(int depth) {
        this.reset();
        for (EObject currentSelectedEObject : this.pattern.getSelectedEObjects()) {
            this.eObjectsDLS(currentSelectedEObject, depth + 1);
        }
    }

    @Override
    public void eObjectsDLS(EObject root, int limit) {
        LinkedList<NodeHelper> stack = new LinkedList<NodeHelper>();
        LinkedList<NodeHelper> actualPathStack = new LinkedList<NodeHelper>();
        NodeHelper startNodeHelper = new NodeHelper(root, 1);
        stack.push(startNodeHelper);
        while (!stack.isEmpty()) {
            NodeHelper v = (NodeHelper)stack.pop();
            if (v.getDepth() > limit) continue;
            if (!actualPathStack.isEmpty() && ((NodeHelper)actualPathStack.peek()).getDepth() >= v.getDepth()) {
                while (((NodeHelper)actualPathStack.peek()).getDepth() >= v.getDepth()) {
                    actualPathStack.pop();
                }
            }
            actualPathStack.push(v);
            if (this.pattern.getSelectedEObjects().contains(v.getNode())) {
                this.registerEIQElements(actualPathStack, root, v.getNode());
            }
            Set<EObject> referredEObjects = this.getAllReferredEObjects(v.getNode());
            block2: for (EObject u : referredEObjects) {
                for (NodeHelper nh : actualPathStack) {
                    if (nh.getNode().equals(u)) continue block2;
                }
                stack.push(new NodeHelper(u, v.getDepth() + 1));
            }
        }
    }

    @Override
    public Set<EObject> getAllReferredEObjects(EObject eo) {
        HashSet<EObject> ret = new HashSet<EObject>();
        EList refList = eo.eClass().getEAllReferences();
        for (EReference ref : refList) {
            ret.addAll(this.navigationHelper.getReferenceValues(eo, ref));
            ret.addAll(this.navigationHelper.getInverseReferences(eo, ref));
        }
        return ret;
    }

    private void registerEIQElements(LinkedList<NodeHelper> path, EObject pathStart, EObject pathEnd) {
        VQLPath currentPath = new VQLPath();
        currentPath.setStart(pathStart);
        currentPath.setEnd(pathEnd);
        int i = path.size() - 1;
        while (i > 0) {
            EObject start = path.get(i).getNode();
            EObject end = path.get(i - 1).getNode();
            if (!this.pattern.getSelectedEObjects().contains(start)) {
                this.variableRegister.registerFreeVariable(start);
                this.pattern.getDiscoveredEObjects().add(start);
                this.pattern.getDiscoveredObjectsAttributes().addAll(this.getAttributesForEObject(start));
            }
            if (!this.pattern.getSelectedEObjects().contains(end)) {
                this.variableRegister.registerFreeVariable(end);
                this.pattern.getDiscoveredEObjects().add(end);
                this.pattern.getDiscoveredObjectsAttributes().addAll(this.getAttributesForEObject(end));
            }
            HashSet<VQLConstraint> constraintsToRegister = new HashSet<VQLConstraint>();
            constraintsToRegister.addAll(this.determineAllConstraints(start, end));
            constraintsToRegister.addAll(this.determineAllConstraints(end, start));
            block1: for (VQLConstraint constraintToRegister : constraintsToRegister) {
                if (this.pattern.getConstraints().contains(constraintToRegister)) {
                    for (VQLConstraint c : this.pattern.getConstraints()) {
                        if (!c.equals(constraintToRegister)) continue;
                        currentPath.getConstraints().add(c);
                        continue block1;
                    }
                    continue;
                }
                this.pattern.getConstraints().add(constraintToRegister);
                currentPath.getConstraints().add(constraintToRegister);
            }
            --i;
        }
        if (!currentPath.getConstraints().isEmpty()) {
            this.pattern.getPaths().add(currentPath);
        }
    }

    @Override
    public Set<VQLConstraint> determineAllConstraints(EObject first, EObject second) {
        HashSet<VQLConstraint> ret = new HashSet<VQLConstraint>();
        EList refList = first.eClass().getEAllReferences();
        for (EReference ref : refList) {
            Set referredObjects = this.navigationHelper.getReferenceValues(first, ref);
            if (!referredObjects.contains(second)) continue;
            ret.add(new VQLConstraint(first, ref, second));
        }
        return ret;
    }

    private void determineAndRegisterAllNegConstraints(EObject first, EObject second) {
        EList refList = first.eClass().getEAllReferences();
        for (EReference ref : refList) {
            if (!ref.getEReferenceType().equals(second.eClass())) continue;
            if (ref.isMany()) {
                Collection targets = (Collection)first.eGet((EStructuralFeature)ref);
                if (targets.contains(second)) continue;
                this.pattern.getNegConstraints().add(new VQLNegConstraint(first, ref, second));
                continue;
            }
            Object target = first.eGet((EStructuralFeature)ref);
            if (target.equals(second)) continue;
            this.pattern.getNegConstraints().add(new VQLNegConstraint(first, ref, second));
        }
    }

    @Override
    public VQLPattern getPattern() {
        return this.pattern;
    }

    @Override
    public void reset() {
        this.variableRegister.reset();
        this.pattern.reset();
    }

    @Override
    public boolean isPatternConnected() {
        return this.pattern.isPatternConnected();
    }

    @Override
    public int determineCoherenceMinimumDepth() {
        if (this.pattern.getSelectedEObjects() == null || this.pattern.getSelectedEObjects().isEmpty()) {
            return 0;
        }
        if (this.pattern.getSelectedEObjects().size() == 1) {
            return 1;
        }
        int ret = 1;
        EObject selectedEObject = this.pattern.getSelectedEObjects().iterator().next();
        while (ret <= 20) {
            this.reset();
            this.eObjectsDLS(selectedEObject, ret + 1);
            if (this.pattern.isPatternConnected()) {
                return ret;
            }
            ++ret;
        }
        return 1;
    }

    @Override
    public void findAndRegisterNegativeConstraints() {
        HashSet<EObject> allEObjectsInPattern = new HashSet<EObject>();
        allEObjectsInPattern.addAll(this.pattern.getSelectedEObjects());
        allEObjectsInPattern.addAll(this.pattern.getDiscoveredEObjects());
        for (EObject first : allEObjectsInPattern) {
            for (EObject second : allEObjectsInPattern) {
                if (first.equals(second)) continue;
                this.determineAndRegisterAllNegConstraints(first, second);
            }
        }
    }

    private List<VQLAttribute> getAttributesForEObject(EObject eo) {
        ArrayList<VQLAttribute> ret = new ArrayList<VQLAttribute>();
        EList attrList = eo.eClass().getEAllAttributes();
        for (EAttribute attr : attrList) {
            Set attributeValues = this.navigationHelper.getFeatureTargets(eo, (EStructuralFeature)attr);
            if (attributeValues == null || attributeValues.size() != 1) continue;
            ret.add(new VQLAttribute(eo, attr, attributeValues.iterator().next()));
        }
        return ret;
    }

    private static class NodeHelper {
        private EObject node;
        private int depth;

        public NodeHelper(EObject n, int d) {
            this.node = n;
            this.depth = d;
        }

        public EObject getNode() {
            return this.node;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

