/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.interfaces.beans;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLAttribute;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLNegConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLPath;

public class VQLPattern {
    private String packageName = "pckgname";
    private String nsUri;
    private String patternName = "patternOne";
    private Set<EObject> selectedEObjects;
    private Set<EObject> discoveredEObjects;
    private Set<VQLConstraint> constraints;
    private Set<VQLNegConstraint> negConstraints;
    private List<VQLPath> paths;
    private List<VQLAttribute> attributes;
    private Set<VQLAttribute> discoveredObjectsAttributes;
    public static final String DEFAULT_PACKAGENAME = "pckgname";
    public static final String DEFAULT_PATTERNNAME = "patternOne";

    public VQLPattern(Set<EObject> selectedEObjects) {
        this.selectedEObjects = selectedEObjects;
        if (this.selectedEObjects != null && !this.selectedEObjects.isEmpty()) {
            this.nsUri = this.selectedEObjects.iterator().next().eClass().getEPackage().getNsURI();
        }
        this.discoveredEObjects = new HashSet<EObject>();
        this.constraints = new HashSet<VQLConstraint>();
        this.negConstraints = new HashSet<VQLNegConstraint>();
        this.paths = new ArrayList<VQLPath>();
        this.attributes = new ArrayList<VQLAttribute>();
        this.discoveredObjectsAttributes = new HashSet<VQLAttribute>();
    }

    public boolean validate() {
        return !this.packageName.trim().isEmpty() && !this.nsUri.trim().isEmpty() && !this.patternName.trim().isEmpty() && !this.selectedEObjects.isEmpty();
    }

    public void reset() {
        this.constraints.clear();
        this.negConstraints.clear();
        this.discoveredEObjects.clear();
        this.paths.clear();
        this.discoveredObjectsAttributes.clear();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPatternName() {
        return this.patternName;
    }

    public void setPatternName(String patternName) {
        this.patternName = patternName;
    }

    public String getNsUri() {
        return this.nsUri;
    }

    public Set<EObject> getSelectedEObjects() {
        return this.selectedEObjects;
    }

    public Set<EObject> getDiscoveredEObjects() {
        return this.discoveredEObjects;
    }

    public Set<VQLConstraint> getConstraints() {
        return this.constraints;
    }

    public Set<VQLNegConstraint> getNegConstraints() {
        return this.negConstraints;
    }

    public List<VQLPath> getPaths() {
        return this.paths;
    }

    public List<VQLAttribute> getAttributes() {
        return this.attributes;
    }

    public Set<VQLAttribute> getDiscoveredObjectsAttributes() {
        return this.discoveredObjectsAttributes;
    }

    public boolean isPatternConnected() {
        EObject start = this.selectedEObjects.iterator().next();
        LinkedList<EObject> queue = new LinkedList<EObject>();
        ArrayList<EObject> vectorSet = new ArrayList<EObject>();
        queue.add(start);
        vectorSet.add(start);
        while (!queue.isEmpty()) {
            EObject t = (EObject)queue.poll();
            for (EObject u : this.getAdjacentNodes(t)) {
                if (vectorSet.contains(u)) continue;
                vectorSet.add(u);
                if (vectorSet.containsAll(this.selectedEObjects)) {
                    return true;
                }
                queue.add(u);
            }
        }
        return false;
    }

    private Set<EObject> getAdjacentNodes(EObject o) {
        HashSet<EObject> ret = new HashSet<EObject>();
        for (VQLConstraint constraint : this.constraints) {
            if (constraint.getStart().equals(o)) {
                ret.add(constraint.getEnd());
            }
            if (!constraint.getEnd().equals(o)) continue;
            ret.add(constraint.getStart());
        }
        return ret;
    }
}

